/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.mouse;

import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.hilight.FkRolloverCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;

public class DiagramMouseMoveCtrl {
    private final FkRolloverCtrl fkRollOverCtrl = new FkRolloverCtrl();
    private final Diagram diagram;
    private List<Glyph> selectedGlyphs;
    private Glyph lastGlyphOver;

    DiagramMouseMoveCtrl(Diagram diagram) {
        this.diagram = diagram;
    }

    void mouseMoved(MouseEvent e, List<Glyph> selectedGlyphs) {
        this.selectedGlyphs = selectedGlyphs;
        this.mouseMoved(e);
    }

    private void mouseMoved(MouseEvent e) {
        boolean wasOverGlyph = this.wasOverGlyph();
        Point p = e.getPoint();
        Glyph overGlyph = this.diagram.getGlyphContainingPoint(p);
        boolean isOverGlyph = overGlyph != null;
        boolean isOverZone = overGlyph instanceof ZoneGlyph;
        this.processPluginOverGlyph(overGlyph);
        if (isOverGlyph && !this.areMultipleGlyphSelected()) {
            this.processClickActions(e);
            this.refreshDiagramPanel();
        }
        if (!this.diagram.isOverHighZLevelGlyph(p)) {
            this.processFkRollovers(e);
            this.refreshDiagramPanel();
        }
        if (isOverZone) {
            this.processClickActions(e);
            this.refreshDiagramPanel();
        }
        if (!isOverGlyph && wasOverGlyph) {
            if (this.lastGlyphOver instanceof IMouseTracker) {
                ((IMouseTracker)((Object)this.lastGlyphOver)).mouseExited(e);
            }
            this.lastGlyphOver = null;
        }
    }

    private void processPluginOverGlyph(Glyph glyph) {
        IDiagramPlugin diagramPlugin = this.diagram.getDiagramPanel().getPlugin();
        if (diagramPlugin != null) {
            diagramPlugin.processOverGlyph(glyph);
        }
    }

    private void refreshDiagramPanel() {
        this.diagram.refreshDiagramPanel();
    }

    private boolean areMultipleGlyphSelected() {
        return this.selectedGlyphs.size() > 1;
    }

    private void processFkRollovers(MouseEvent e) {
        this.fkRollOverCtrl.highlightLinkUnderPt(this.diagram, e);
        if (this.fkRollOverCtrl.doDiagramRefresh()) {
            this.refreshDiagramPanel();
        }
    }

    private void processClickActions(MouseEvent e) {
        for (Glyph glyph : this.diagram.getGlyphs(true)) {
            if (glyph instanceof IMouseTracker) {
                ((IMouseTracker)((Object)glyph)).mouseMoved(e);
            }
            if (!glyph.contains(e.getPoint())) continue;
            this.lastGlyphOver = glyph;
        }
    }

    private boolean wasOverGlyph() {
        return this.lastGlyphOver != null;
    }
}

