/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.mouse;

import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.sketch.core.Glyph;
import java.awt.event.MouseEvent;
import java.util.List;

public class DiagramMouseDownCtrl {
    private boolean addGlyphToSelectionFlag;
    private boolean unselectGlyphsFlag;
    private boolean startSelectingFlag;
    private Glyph clickedGlyph;
    private MouseEvent evt;
    private List selectedGlyphs;
    private boolean ctrl;

    public void mouseDown(MouseEvent evt, Glyph clickedGlyph, List selectedGlyphs) {
        this.resetFlags();
        this.evt = evt;
        this.clickedGlyph = clickedGlyph;
        this.selectedGlyphs = selectedGlyphs;
        boolean isControlDown = evt.isControlDown();
        boolean isMetaDown = evt.isMetaDown();
        this.ctrl = isControlDown || isMetaDown;
        boolean clickActionClicked = this.checkClickActionClicked();
        if (clickActionClicked) {
            return;
        }
        if (this.getHasSelections()) {
            this.processHasSelections();
        } else {
            this.startSelectingFlag = true;
        }
    }

    private boolean getHasSelections() {
        return !this.selectedGlyphs.isEmpty();
    }

    private void processHasSelections() {
        if (this.clickedGlyph != null) {
            this.processGlyphClicked();
        } else {
            this.processNoGlyphClicked();
        }
    }

    private void processNoGlyphClicked() {
        if (!this.ctrl) {
            this.unselectGlyphsFlag = true;
        }
        this.startSelectingFlag = true;
    }

    private void processGlyphClicked() {
        if (!this.clickedGlyph.getSelected()) {
            if (this.ctrl) {
                this.addGlyphToSelectionFlag = true;
                this.unselectGlyphsFlag = false;
                this.startSelectingFlag = false;
            } else {
                this.unselectGlyphsFlag = true;
                this.startSelectingFlag = true;
            }
        }
    }

    private boolean checkClickActionClicked() {
        boolean clickProcessed = false;
        if (this.selectedGlyphs.size() <= 1 && this.clickedGlyph instanceof IMouseTracker) {
            this.unselectGlyphsFlag = true;
            this.startSelectingFlag = true;
            clickProcessed = ((IMouseTracker)((Object)this.clickedGlyph)).mouseDown(this.evt);
        }
        return clickProcessed;
    }

    public boolean isAddGlyphToSelectionFlag() {
        return this.addGlyphToSelectionFlag;
    }

    public boolean isStartSelectingFlag() {
        return this.startSelectingFlag;
    }

    public boolean isUnselectGlyphsFlag() {
        return this.unselectGlyphsFlag;
    }

    private void resetFlags() {
        this.addGlyphToSelectionFlag = false;
        this.startSelectingFlag = false;
        this.unselectGlyphsFlag = false;
    }
}

