/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.mouse;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.Lasso;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.glyph.GlyphMoveCtrl;
import com.harrand.sketch.glyph.mgr.GlyphSelectionMgr;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import com.harrand.sketch.j2d.mouse.DiagramMouseDownCtrl;
import com.harrand.sketch.j2d.mouse.DiagramMouseMoveCtrl;
import com.harrand.sketch.panel.diagram.IDiagramPanel;
import com.harrand.sketch.relation.line.LineLinkPair;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.LineMoveCtrl;
import com.harrand.sketch.relation.mouse.DiagramLineTracker;
import com.harrand.sketch.support.GlyphResizeCtrl;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.SwingUtilities;

public final class DiagramMouseCtrl {
    private final GlyphResizeCtrl resizeCtrl = new GlyphResizeCtrl();
    private final LineMoveCtrl lineMoveCtrl = LineMoveCtrl.getInstance();
    private final GlyphMoveCtrl glyphMoveCtrl = new GlyphMoveCtrl();
    private boolean isMovingGlyphs = false;
    private final DiagramLineTracker lineTracker;
    private final GlyphSelectionMgr selectionMgr;
    private final DiagramMouseDownCtrl mouseDownCtrl = new DiagramMouseDownCtrl();
    private final DiagramMouseMoveCtrl mouseMoveCtrl;
    private IDiagramPanel diagramPanel;
    private final Diagram diagram;
    private Lasso lasso;
    private Point dragStart;
    private int dragX;
    private int dragY;

    public DiagramMouseCtrl(Diagram diagram) {
        this.diagram = diagram;
        this.selectionMgr = this.diagram.getSelectionMgr();
        this.mouseMoveCtrl = new DiagramMouseMoveCtrl(this.diagram);
        this.lineTracker = new DiagramLineTracker(this.diagram);
    }

    public void setIDiagramPanel(IDiagramPanel iDiagramPanel) {
        this.diagramPanel = iDiagramPanel;
    }

    public void mouseMoved(MouseEvent e) {
        List<Glyph> selectedGlyphs = this.getSelectedGlyphs(true);
        this.mouseMoveCtrl.mouseMoved(e, selectedGlyphs);
    }

    public void mouseUp(MouseEvent evt) {
        if (this.hasDragged() && !this.resizeCtrl.isActive()) {
            this.moveGlyphsOnMouseUp(evt.getPoint());
        }
        if (this.lasso != null) {
            this.lasso = null;
            this.diagramPanel.refresh();
        }
        this.dragX = 0;
        this.dragY = 0;
        this.lineMoveCtrl.setLine(null, null);
        this.isMovingGlyphs = false;
        this.resizeCtrl.clear();
        this.refreshPanel();
        this.mouseUpOnSelectedGlyphs(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        Point mousePoint = evt.getPoint();
        boolean ctrl = evt.isControlDown();
        PositionableLine currentDragLine = this.lineMoveCtrl.getLine();
        boolean isLineSelected = currentDragLine != null;
        boolean isOverLine = this.lineTracker.getContainingLine(mousePoint) != null;
        boolean isLineMove = isLineSelected || isOverLine;
        boolean hasSelectedGlyphs = this.hasSelectedGlyphs(false);
        if (this.lasso != null) {
            this.processLassoDrag(evt, ctrl);
        } else if (isLineMove && !this.isMovingGlyphs) {
            this.processLineDrag(mousePoint);
        } else if (hasSelectedGlyphs) {
            this.processGlyphDrag(mousePoint);
        }
        this.refreshPanel();
    }

    private void processLassoDrag(MouseEvent evt, boolean ctrl) {
        this.lasso.setCursor(evt.getPoint());
        List<Glyph> prevSelGlyphs = ctrl ? this.getSelectedGlyphs(false) : null;
        this.lasso.setSelectedGlyphs(this.getGlyphs(), prevSelGlyphs);
    }

    private void processLineDrag(Point zoomedPt) {
        boolean lineActive;
        Line2D newDragLine;
        LineLinkPair lineLinkPair;
        Line2D currentDragLine = this.lineMoveCtrl.getLine();
        if (currentDragLine == null && (lineLinkPair = this.lineTracker.getContainingLine(zoomedPt)) != null && (newDragLine = lineLinkPair.getLine()) != null && newDragLine instanceof PositionableLine) {
            currentDragLine = newDragLine;
            Link link = lineLinkPair.getLink();
            this.lineMoveCtrl.setLine((PositionableLine)currentDragLine, link);
        }
        boolean bl = lineActive = currentDragLine != null;
        if (lineActive) {
            Point diagramPt = this.diagram.getDiagramPt(zoomedPt);
            this.lineMoveCtrl.moveLine(diagramPt);
            Database base = LookupUtil.findDb();
            base.notifyDirty(currentDragLine);
            this.diagram.refresh();
        }
    }

    private void processGlyphDrag(Point p) {
        this.dragX = (int)p.getX() - (int)this.dragStart.getX();
        this.dragY = (int)p.getY() - (int)this.dragStart.getY();
        Glyph clickedGlyph = this.getGlyphContainingPoint(this.dragStart);
        boolean anchorActive = this.resizeCtrl.checkAnchorActivated(clickedGlyph, p, this.getZoom());
        this.isMovingGlyphs = true;
        if (anchorActive) {
            this.resizeGlyphDisp(p);
        } else {
            this.glyphMoveCtrl.moveGlyphsWithDrag(this.diagram, p);
        }
    }

    public void mouseDown(MouseEvent evt) {
        IDiagramPlugin diagramPlugin;
        Point p;
        if (this.resizeCtrl.isActive()) {
            return;
        }
        this.dragStart = p = evt.getPoint();
        this.glyphMoveCtrl.initDrag(new Point(p));
        List<Glyph> selectedGlyphs = this.getSelectedGlyphs(true);
        Glyph clickedGlyph = this.getGlyphContainingPoint(p);
        this.mouseDownCtrl.mouseDown(evt, clickedGlyph, selectedGlyphs);
        if (this.mouseDownCtrl.isAddGlyphToSelectionFlag()) {
            this.addGlyphToSelection(clickedGlyph);
        }
        if (this.mouseDownCtrl.isUnselectGlyphsFlag()) {
            this.unselectGlyphs();
        }
        if (this.mouseDownCtrl.isStartSelectingFlag()) {
            this.startSelecting(evt);
        }
        if ((diagramPlugin = this.diagramPanel.getPlugin()) != null) {
            diagramPlugin.processMouseDown();
        }
    }

    public void cancelDrag() {
        this.lasso = null;
        this.resizeCtrl.clear();
        this.unselectGlyphs();
    }

    public GlyphResizeCtrl getResizeCtrl() {
        return this.resizeCtrl;
    }

    private void startSelecting(MouseEvent evt) {
        Point p = evt.getPoint();
        if (!this.attemptGlyphSelect(p) && SwingUtilities.isLeftMouseButton(evt)) {
            this.lasso = new Lasso(p, this.diagram.getZoom().getLevel());
        }
    }

    private boolean attemptGlyphSelect(Point p) {
        boolean success = false;
        Glyph selectedGlyph = this.getGlyphContainingPoint(p);
        if (selectedGlyph != null) {
            this.setSelectedGlyph(selectedGlyph.getName());
            success = true;
        }
        return success;
    }

    private void unselectGlyphs() {
        this.selectionMgr.unselectGlyphs();
    }

    private boolean hasDragged() {
        return this.dragX != 0 || this.dragY != 0;
    }

    private void moveGlyphsOnMouseUp(Point mousePt) {
        this.glyphMoveCtrl.moveGlyphsOnMouseUp(this.diagram, mousePt);
    }

    private void refreshPanel() {
        if (this.hasPanel()) {
            this.diagramPanel.refresh();
        }
    }

    private boolean hasPanel() {
        return this.diagramPanel != null;
    }

    public Lasso getLasso() {
        return this.lasso;
    }

    private List<Glyph> getGlyphs() {
        return this.diagram.getOnlyGlyphs();
    }

    private Glyph getGlyphContainingPoint(Point p) {
        return this.diagram.getGlyphContainingPoint(p);
    }

    private boolean hasSelectedGlyphs(boolean includeLinks) {
        return this.selectionMgr.hasSelectedGlyphs(includeLinks);
    }

    private List<Glyph> getSelectedGlyphs(boolean includeLinks) {
        return this.selectionMgr.getSelectedGlyphs(includeLinks);
    }

    private void resizeGlyphDisp(Point mousePt) {
        this.diagram.resizeGlyphDisp(mousePt);
    }

    private Zoom getZoom() {
        return this.diagram.getZoom();
    }

    private void setSelectedGlyph(String glyphNm) {
        this.selectionMgr.setSelectedGlyph(glyphNm);
    }

    private void addGlyphToSelection(Glyph glyph) {
        this.selectionMgr.addGlyphToSelection(glyph);
    }

    private void mouseUpOnSelectedGlyphs(MouseEvent evt) {
        for (Glyph glyph : this.getSelectedGlyphs(true)) {
            if (!(glyph instanceof IMouseTracker)) continue;
            ((IMouseTracker)((Object)glyph)).mouseUp(evt);
        }
    }
}

