/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.highLight;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.dbwrench.diagram.hilight.color.BlueColorScheme;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.draw.shape.helper.FillRectHelper;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public class RoundRectHighLighter {
    private RoundRectangle2D rect;
    private final ArrayList<IDrawable> selectionShapes = new ArrayList();
    private IColorScheme colorScheme = BlueColorScheme.getInstance();

    private void setRect(RoundRectangle2D newRect) {
        this.rect = new RoundRectangle2D.Double(newRect.getX(), newRect.getY(), newRect.getWidth() + 1.0, newRect.getHeight() + 1.0, newRect.getArcWidth(), newRect.getArcHeight());
    }

    public boolean isRectSame(RoundRectangle2D newRect) {
        return GeometryHelper.isRectSame(this.rect, newRect);
    }

    private boolean canReuseShapes(RoundRectangle2D newRect) {
        if (this.selectionShapes.isEmpty()) {
            return false;
        }
        boolean isSameRect = this.isRectSame(newRect);
        return isSameRect;
    }

    public List<IDrawable> getHilightShapes(RoundRectangle2D roundRect, Zoom zoom) {
        if (this.canReuseShapes(roundRect)) {
            return this.selectionShapes;
        }
        this.setRect(roundRect);
        int count = 4;
        int i = 0;
        this.updateHighlightRect(i++, count, this.colorScheme.getColorD());
        this.updateHighlightRect(i++, count, this.colorScheme.getColorC());
        this.updateHighlightRect(i++, count, this.colorScheme.getColorB());
        this.updateHighlightRect(i++, count, this.colorScheme.getColorA());
        return this.selectionShapes;
    }

    public List<IDrawable> getHilightShapesGreen(RoundRectangle2D roundRect, Zoom zoom) {
        if (this.canReuseShapes(roundRect)) {
            return this.selectionShapes;
        }
        this.setRect(roundRect);
        int count = 5;
        int i = 0;
        this.updateHighlightRect(i++, count, Colors.getGreenUltraLight());
        this.updateHighlightRect(i++, count, Colors.getGreenVeryLight());
        this.updateHighlightRect(i++, count, Colors.getGreenLighter());
        this.updateHighlightRect(i++, count, Colors.getGreenLight());
        this.updateHighlightRect(i++, count, Colors.getGreenLight());
        return this.selectionShapes;
    }

    public List<IDrawable> getHilightShapesLite(RoundRectangle2D roundRect, Zoom zoom) {
        if (this.canReuseShapes(roundRect)) {
            return this.selectionShapes;
        }
        this.setRect(roundRect);
        int count = 3;
        int i = 0;
        this.updateHighlightRect(i++, count, Colors.getBlueHiLightD());
        this.updateHighlightRect(i++, count, Colors.getBlueHiLightC());
        this.updateHighlightRect(i++, count, Colors.getBlueHiLightB());
        return this.selectionShapes;
    }

    private void updateHighlightRect(int i, int count, Color color) {
        EnhancedShape eShape = null;
        int offset = count - i;
        if (i < this.selectionShapes.size()) {
            EnhancedShape currentE_Shape = (EnhancedShape)this.selectionShapes.get(i);
            FillRectHelper.updateFillRectShape(currentE_Shape, this.rect, offset, color);
            eShape = currentE_Shape;
        } else {
            eShape = FillRectHelper.createFillRectShape(this.rect, offset, color);
            this.selectionShapes.add(eShape);
        }
    }

    public void setColorScheme(IColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public void clearSelectionShapes() {
        this.selectionShapes.clear();
    }
}

