/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.sketch.core.VerbosityConfig;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public final class VerbosityPanel
extends JPanel
implements DataEditor {
    private VerbosityConfig verbosity_;
    private Map showBoxes_ = new TreeMap();
    private HeaderPanel hdrTitle_;
    private ActionListener lisShowFlag_;
    private SwingThemeCtrl themeCtrl_;
    private String title_;

    public VerbosityPanel(VerbosityConfig verbosity) {
        this.initComponents();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setVerbosityConfig(verbosity);
        this.title_ = "Verbosity Config";
        this.buildPanel();
    }

    private void buildPanel() {
        this.initComponents();
        this.buildListeners();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.refresh();
    }

    private void layoutComponents() {
        this.setShowBoxes();
        int columnCount = 3;
        int chkBoxCount = this.showBoxes_.size() - 2;
        int rows = chkBoxCount / columnCount;
        if (chkBoxCount % columnCount == 0) {
            ++rows;
        }
        this.setLayout(new GridLayout(++rows, columnCount));
        this.addShowBoxes();
    }

    private void setMnemonics() {
        for (JCheckBox chkBox : this.showBoxes_.values()) {
            String text = chkBox.getText();
            if (text.equalsIgnoreCase("auto number")) {
                chkBox.setMnemonic('u');
            }
            if (text.equalsIgnoreCase("data type")) {
                chkBox.setMnemonic('d');
            }
            if (text.equalsIgnoreCase("enum values")) {
                chkBox.setMnemonic('v');
            }
            if (text.equalsIgnoreCase("name")) {
                chkBox.setMnemonic('n');
            }
            if (text.equalsIgnoreCase("schema name")) {
                chkBox.setMnemonic('h');
            }
            if (text.equalsIgnoreCase("comment")) {
                chkBox.setMnemonic('m');
            }
            if (text.equalsIgnoreCase("default")) {
                chkBox.setMnemonic('t');
            }
            if (text.equalsIgnoreCase("length")) {
                chkBox.setMnemonic('l');
            }
            if (text.equalsIgnoreCase("nullable")) {
                chkBox.setMnemonic('b');
            }
            if (!text.equalsIgnoreCase("signed")) continue;
            chkBox.setMnemonic('g');
        }
    }

    private void setShowBoxes() {
        this.showBoxes_.clear();
        for (String key : this.verbosity_.getShowKeys()) {
            JCheckBox box = new JCheckBox(key, this.verbosity_.getShowFlag(key));
            this.themeCtrl_.process(box);
            box.setName(key);
            box.addActionListener(this.lisShowFlag_);
            this.showBoxes_.put(key, box);
        }
    }

    private void addShowBoxes() {
        for (JCheckBox chk : this.showBoxes_.values()) {
            if (chk.getText().endsWith("Check")) continue;
            this.add(chk);
        }
    }

    private void refresh() {
        for (String key : this.showBoxes_.keySet()) {
            JCheckBox box = (JCheckBox)this.showBoxes_.get(key);
            box.setSelected(this.verbosity_.getShowFlag(key));
        }
    }

    private void setCosmetics() {
        this.hdrTitle_ = new HeaderPanel(this.title_);
        this.themeCtrl_.process(this);
        this.setMnemonics();
        this.setBorder(BorderFactory.createTitledBorder("Display Fields"));
    }

    private void setNames() {
        this.hdrTitle_.setName("hdrTitle");
    }

    private void buildListeners() {
        this.lisShowFlag_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerbosityPanel.this.validateData();
            }
        };
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        try {
            this.syncData();
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
            this.verbosity_ = null;
        }
        return result;
    }

    private void syncData() throws Exception {
        for (String key : this.showBoxes_.keySet()) {
            JCheckBox box = (JCheckBox)this.showBoxes_.get(key);
            this.verbosity_.setShowFlag(key, box.isSelected());
        }
    }

    public void setVerbosityConfig(VerbosityConfig verbosity) {
        this.verbosity_ = verbosity.duplicate();
        this.refresh();
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.verbosity_;
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 170, 250);
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }
}

