/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class NavPrototypePanel
extends JPanel
implements ITitled,
ISized {
    private DiagramPanel diagramPanel_;
    private BufferedImage diagramImg_;
    private JPanel panImage_ = new JPanel();
    private JButton btnRefresh_ = ButtonUtil.getRefreshBtn();
    private JTextField txtZoom_ = new JTextField("0.9", 5);
    private ActionListener lisRefresh_;

    public NavPrototypePanel(DiagramPanel diagramPanel) {
        this.diagramPanel_ = diagramPanel;
        this.setupGui();
    }

    private BufferedImage getImageFromFile() {
        try {
            return ImageIO.read(new File("C:\\Harnek\\Java\\com\\harrand\\dbwrench\\userdata\\images\\ee.png"));
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            return null;
        }
    }

    public void refresh() {
        if (this.diagramImg_ != null) {
            LogUtil.logMsg("NavPan.img NOT null");
            Graphics2D gfx = (Graphics2D)this.panImage_.getGraphics();
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gfx.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            gfx.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            gfx.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            try {
                double zoom = Double.parseDouble(this.txtZoom_.getText());
                AffineTransform tx = new AffineTransform();
                tx.scale(zoom, zoom);
                AffineTransformOp txOp = new AffineTransformOp(tx, 2);
                gfx.drawImage(this.diagramImg_, txOp, 0, 0);
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        } else {
            LogUtil.logMsg("NavPan.img NULL");
        }
    }

    private void setupGui() {
        this.layoutComponents();
        this.buildListeners();
        this.addListeners();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panImage_, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.txtZoom_);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnRefresh_);
        return buttonPanel;
    }

    private void buildListeners() {
        this.lisRefresh_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavPrototypePanel.this.refresh();
            }
        };
    }

    private void addListeners() {
        this.btnRefresh_.addActionListener(this.lisRefresh_);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Navigator";
    }

    @Override
    public String getToolTip() {
        return "Navigator";
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 700, 550);
    }
}

