/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.display.Colors;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphBox;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.GlyphSeperator;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.Renderer;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.ThickArc;
import com.harrand.sketch.j2d.ThickLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.List;

public class J2dRenderer
implements Renderer {
    private Graphics2D g2_;
    private RenderConfig renderConfig_;
    private FontRenderContext frc_;

    private void validateInputs() throws IllegalArgumentException {
        if (this.g2_ == null) {
            throw new IllegalArgumentException("g2 can not be null.");
        }
    }

    @Override
    public void render(Glyph glyph) {
    }

    public void renderShapes(List shapes) {
        for (Object obj : shapes) {
            if (obj instanceof Glyph) {
                this.renderGlyphDisp((Glyph)obj);
                continue;
            }
            if (obj instanceof EnhancedShape) {
                this.render((EnhancedShape)obj);
                continue;
            }
            if (obj instanceof ThickLine) {
                this.render((ThickLine)obj);
                continue;
            }
            if (obj instanceof ThickArc) {
                this.render((ThickArc)obj);
                continue;
            }
            if (obj instanceof GlyphTextLine) {
                this.render((GlyphTextLine)obj);
                continue;
            }
            if (!(obj instanceof Shape)) continue;
            this.render((Shape)obj);
        }
    }

    private void renderGlyphDisp(Glyph glyph) {
        if (glyph instanceof IPreImagedGlyph) {
            this.render((IPreImagedGlyph)((Object)glyph));
        } else if (glyph instanceof GlyphTextLine) {
            this.render((GlyphTextLine)glyph);
        } else if (glyph instanceof GlyphBox) {
            this.render((GlyphBox)glyph);
        } else if (glyph instanceof GlyphImage) {
            this.render((GlyphImage)glyph);
        } else if (glyph instanceof GlyphSeperator) {
            this.render((GlyphSeperator)glyph);
        }
    }

    public void render(IPreImagedGlyph preGlyph) {
    }

    private void render(GlyphTextLine textLine) {
    }

    public void render(GlyphBox box) {
    }

    public void render(GlyphImage glyphImage) {
    }

    private void render(GlyphSeperator sep) {
    }

    private void render(EnhancedShape enhancedShape) {
    }

    private void render(ThickLine thickLine) {
    }

    private void render(ThickArc thickArc) {
    }

    private void render(Shape shape) {
        this.g2_.draw(shape);
    }

    private void render(Image image, Point2D point) {
        this.g2_.drawImage(image, (int)point.getX(), (int)point.getX(), null);
    }

    @Override
    public Rectangle2D getStringBounds(GlyphTextLine textGlyph) {
        this.g2_.setFont(textGlyph.getFont());
        return this.g2_.getFont().getStringBounds(textGlyph.getText(), this.frc_);
    }

    @Override
    public void renderShading(RoundRectangle2D rect) {
        int level = 3;
        Paint oldPaint = this.g2_.getPaint();
        double r = rect.getArcWidth();
        double halfR = 0.5 * r;
        double minX = rect.getMinX();
        double maxX = rect.getMaxX();
        double minY = rect.getMinY();
        double maxY = rect.getMaxY();
        for (int i = 1; i <= level; ++i) {
            int startOffset = i - 2;
            int endOffset = i - 1;
            Line2D.Double bottomLine = new Line2D.Double(minX + halfR + (double)startOffset, maxY + (double)i, maxX - halfR + (double)endOffset, maxY + (double)i);
            Line2D.Double rightLine = new Line2D.Double(maxX + (double)i, minY + halfR + (double)startOffset, maxX + (double)i, maxY - halfR + (double)endOffset);
            Arc2D.Double arcBottom = new Arc2D.Double(maxX - r + (double)i, maxY - r + (double)i, r, r, 270.0, 90.0, 0);
            this.g2_.setPaint(Colors.getGrayLight());
            this.g2_.draw(bottomLine);
            this.g2_.draw(rightLine);
            Stroke oldStroke = this.g2_.getStroke();
            this.g2_.setStroke(new BasicStroke(1.5f));
            this.g2_.draw(arcBottom);
            this.g2_.setStroke(oldStroke);
        }
        Line2D.Double topLine = new Line2D.Double(minX + halfR + 1.0, minY + 1.0, maxX - halfR + 1.0, minY + 1.0);
        Line2D.Double leftLine = new Line2D.Double(minX + 1.0, minY + halfR + 1.0, minX + 1.0, maxY - halfR + 1.0);
        Arc2D.Double arcTop = new Arc2D.Double(minX + 1.0, minY + 1.0, r, r, 90.0, 90.0, 0);
        this.g2_.setPaint(Color.WHITE);
        this.g2_.draw(topLine);
        this.g2_.draw(leftLine);
        this.g2_.draw(arcTop);
        this.g2_.setPaint(oldPaint);
    }

    @Override
    public void setRenderConfig(RenderConfig renderConfig) {
        this.renderConfig_ = renderConfig;
    }

    public void setGraphics(Graphics2D g2) {
        this.g2_ = g2;
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.renderConfig_;
    }
}

