/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.display.color.BasicColorable2;
import com.harrand.coreclasses.display.color.IColorable2;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.xml.svg.bldr.glyph.SvgEnhancedShapeBldr;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnhancedShape
implements IDrawable,
ISvgShape,
IColorable2 {
    private Shape shape;
    private final BasicColorable2 colorable2 = new BasicColorable2();
    private boolean isStroked = true;
    private boolean isDashed;
    private boolean isFilled;
    private boolean useGradient;
    private Paint gradientPaint;
    private int thickness = 1;
    private boolean ignoreZoom;
    private String name;

    public EnhancedShape(Shape shape) {
        this.setShape(shape);
    }

    public EnhancedShape(Shape shape, Color color) {
        this.setShape(shape);
        this.colorable2.setFillColor(color);
        this.colorable2.setStrokeColor(color);
    }

    public EnhancedShape(Shape shape, Color color, boolean useGradient) {
        this.setShape(shape);
        this.colorable2.setFillColor(color);
        this.colorable2.setStrokeColor(color);
        this.useGradient = useGradient;
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setIgnoreZoom(boolean ignoreZoom) {
        this.ignoreZoom = ignoreZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        Shape zoomedShape = this.shape;
        if (!this.ignoreZoom) {
            zoomedShape = Zoomer.zoomDisp(this.shape, zoom);
        }
        Paint oldPaint = g2.getPaint();
        Color strokeColor = this.getStrokeColor();
        g2.setPaint(strokeColor);
        if (this.isFilled) {
            g2.fill(zoomedShape);
        }
        if (this.gradientPaint != null) {
            g2.setPaint(this.gradientPaint);
            g2.fill(zoomedShape);
        }
        if (this.isStroked) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.getStroke());
            g2.draw(zoomedShape);
            g2.setStroke(oldStroke);
        }
        g2.setPaint(oldPaint);
    }

    private Stroke getStroke() {
        if (this.isDashed) {
            return this.getDashStroke();
        }
        return new BasicStroke(this.thickness);
    }

    private Stroke getDashStroke() {
        float[] dashes = new float[]{4.0f, 3.0f};
        BasicStroke stroke = new BasicStroke(this.thickness, 0, 1, 0.0f, dashes, 0.0f);
        return stroke;
    }

    @Override
    public Element getSvgElm(Document doc) {
        SvgEnhancedShapeBldr bldr = new SvgEnhancedShapeBldr(doc);
        return bldr.buildElm(this);
    }

    @Override
    public void setStrokeColor(Color color) {
        this.colorable2.setStrokeColor(color);
    }

    @Override
    public void setTextColor(Color color) {
        this.colorable2.setTextColor(color);
    }

    @Override
    public void setFillColor(Color color) {
        this.colorable2.setFillColor(color);
    }

    @Override
    public Color getStrokeColor() {
        return this.colorable2.getStrokeColor();
    }

    @Override
    public Color getFillColor() {
        return this.colorable2.getFillColor();
    }

    @Override
    public Color getTextColor() {
        return this.colorable2.getTextColor();
    }

    public void setIsFilled(boolean isFilled) {
        this.isFilled = isFilled;
    }

    public void setIsDashed(boolean isDashed) {
        this.isDashed = isDashed;
    }

    public boolean getIsFilled() {
        return this.isFilled;
    }

    public boolean getIsDashed() {
        return this.isDashed;
    }

    public boolean getIsStroked() {
        return this.isStroked;
    }

    public void setIsStroked(boolean isStroked) {
        this.isStroked = isStroked;
    }

    public void setGradientPaint(Paint gradientPaint) {
        this.gradientPaint = gradientPaint;
    }

    public boolean isUseGradient() {
        return this.useGradient;
    }

    public void setUseGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }
}

