/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.dnd.IDragSource;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.sketch.command.ChangePanelDiagram;
import com.harrand.sketch.command.IDeleteGlyphsCmdFactory;
import com.harrand.sketch.command.IDiagramCmdBldr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphLocator;
import com.harrand.sketch.core.IDiagramSrv;
import com.harrand.sketch.interfaces.IDiagramPanelMouseHelper;
import com.harrand.sketch.interfaces.INavigator;
import com.harrand.sketch.interfaces.INavigatorSrc;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.layout.ILayoutCtrl;
import com.harrand.sketch.zoom.IZoomablePanel;
import com.harrand.sketch.zoom.ZoomCtrlMgr;
import com.harrand.sketch.zoom.ZoomToolbar;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Deprecated
public final class DiagramTabPanel
extends JPanel
implements IObserver,
IObservable,
IZoomablePanel,
ChangeListener,
INavigatorSrc,
MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener,
IZoomable {
    private IDiagramSrv diagramSrv_;
    private List diagrams_ = new ArrayList();
    private DiagramPanel diagramPanel_;
    private ZoomToolbar zoomToolBar_;
    private JTabbedPane tabPane_ = new JTabbedPane(3);
    private GlyphLocator glyphLocator_;
    private INavigator navigator_;
    private JScrollBar hbar_;
    private JScrollBar vbar_;
    private ImageIcon icon_ = Icons.DIAGRAM;
    private JScrollPane scrollPane_;
    private ViewportMoveCtrl viewportMoveCtrl_;
    private BasicObservable observable_ = new BasicObservable();
    private Point slideStart_ = null;
    private Point preSlideOrigin_ = null;
    private ZoomCtrlMgr zmCtrlMgr_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    private ChangeListener lisTabChange_;
    private CommandChain cmdChain_;
    private String locateGlyphNm_ = "";
    private Diagram locateGlyphDiagram_ = null;
    private boolean updateNvFlag_ = true;
    private static final String CLZ = "DiagramTabPanel";
    private static final int SCROLL_BAR_UNIT_INCREMENT = 10;

    @Deprecated
    public DiagramTabPanel(IDiagramSrv diagramSrv) {
        this.diagramSrv_ = diagramSrv;
        Dimension size = new Dimension(0, 0);
        if (this.diagramSrv_ != null) {
            this.diagramSrv_.addObserver(this);
            size = this.diagramSrv_.getMaxSize();
        }
        this.zmCtrlMgr_ = new ZoomCtrlMgr(this.diagramSrv_);
        this.diagramPanel_.addObserver(this);
        this.glyphLocator_ = new GlyphLocator(this.diagramSrv_);
        this.buildPanel();
        this.setNames();
        this.refresh();
        this.addListeners();
        this.setCosmetics();
        this.scrollPane_.addMouseListener(this);
        this.scrollPane_.addMouseMotionListener(this);
        this.scrollPane_.setFocusable(true);
        this.scrollPane_.addKeyListener(this);
        this.scrollPane_.addMouseWheelListener(this);
        this.diagramPanel_.setNavigatorSrc(this);
    }

    public void setDiagramSrv(IDiagramSrv diagramSrv) {
        this.tabPane_.removeChangeListener(this.lisTabChange_);
        this.tabPane_.removeAll();
        this.tabPane_.addTab("-", this.icon_, this.scrollPane_);
        this.addTabPaneChangeListener();
        this.diagramPanel_.setDiagram(null);
        this.diagramSrv_ = diagramSrv;
        if (this.diagramSrv_ != null) {
            this.diagramSrv_.addObserver(this);
        }
        this.glyphLocator_ = new GlyphLocator(this.diagramSrv_);
        this.zmCtrlMgr_.setDiagramSrv(this.diagramSrv_);
        this.refresh();
    }

    public void setCommandChain(CommandChain cmdChain) {
        this.cmdChain_ = cmdChain;
    }

    public void setDiagramCmdBldr(IDiagramCmdBldr diagramCmdBldr) {
        this.diagramPanel_.setDiagramCmdBldr(diagramCmdBldr);
    }

    public void setDeleteGlyphsCmdFactory(IDeleteGlyphsCmdFactory factory) {
        this.diagramPanel_.setDeleteGlyphsCmdFactory(factory);
    }

    public void setLayoutCtrl(ILayoutCtrl layoutCtrl) {
    }

    public void setDiagramPanelMouseHelper(IDiagramPanelMouseHelper helper) {
    }

    public void setNavigator(INavigator navigator) {
        this.navigator_ = navigator;
        this.navigator_.setDiagram(this.diagramPanel_.getDiagram());
        this.updateNavigatorPortal();
        this.navigator_.setNavigatorSrc(this);
        this.navigator_.addObserver(this);
    }

    private void buildPanel() {
        this.scrollPane_ = new JScrollPane(this.diagramPanel_, 22, 32);
        this.hbar_ = this.scrollPane_.getHorizontalScrollBar();
        this.vbar_ = this.scrollPane_.getVerticalScrollBar();
        this.viewportMoveCtrl_ = new ViewportMoveCtrl(this.scrollPane_.getViewport());
        this.viewportMoveCtrl_.addObserver(this);
        this.addScrollBarListeners();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane_, "Center");
        this.themeCtrl_.process(this.tabPane_);
        this.themeCtrl_.process(this.scrollPane_);
    }

    public void setBusyCursor() {
        GuiHelper.setBusyCursor(this.diagramPanel_);
    }

    public void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this.diagramPanel_);
    }

    @Override
    public String toString() {
        return CLZ;
    }

    private void setCosmetics() {
        this.setScrollIncrements();
    }

    private void addListeners() {
        this.lisTabChange_ = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                String diagramName = pane.getTitleAt(pane.getSelectedIndex());
                Diagram diagram = DiagramTabPanel.this.diagramSrv_.getDiagram(diagramName);
                DiagramTabPanel.this.setDiagram(diagram);
                DiagramTabPanel.this.notifyObservers(null);
            }
        };
        this.addTabPaneChangeListener();
    }

    private void addScrollBarListeners() {
        this.hbar_.getModel().addChangeListener(this);
        this.vbar_.getModel().addChangeListener(this);
    }

    private void removeScrollBarListeners() {
        this.hbar_.getModel().removeChangeListener(this);
        this.vbar_.getModel().removeChangeListener(this);
    }

    private void setNames() {
        this.scrollPane_.setName("scrollPane");
        this.tabPane_.setName("tabPane");
        this.vbar_.setName("vbar");
        this.hbar_.setName("hbar");
        this.setName(CLZ);
    }

    public void refresh() {
        if (this.diagramSrv_ != null) {
            this.diagrams_ = this.diagramSrv_.getDiagrams();
        }
        this.refreshTabs();
    }

    public void locateGlyph(String glyphNm) {
    }

    private void locateGlyphDetails(Diagram glyphDiagram, String glyphNm, boolean doSlide) {
    }

    public JPanel getPropertyPanel() {
        return this.diagramPanel_.getPropertyPanel();
    }

    public Diagram getDiagram() {
        return this.diagramPanel_.getDiagram();
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel_;
    }

    public int getTabCount() {
        return this.tabPane_.getTabCount();
    }

    private void refreshTabs() {
        Diagram showDiagram = null;
        this.tabPane_.removeChangeListener(this.lisTabChange_);
        if (this.diagrams_.size() > 0) {
            String lastTitle = null;
            if (this.tabPane_.getSelectedIndex() > -1) {
                lastTitle = this.tabPane_.getTitleAt(this.tabPane_.getSelectedIndex());
            }
            while (this.diagrams_.size() != this.tabPane_.getTabCount()) {
                if (this.diagrams_.size() > this.tabPane_.getTabCount()) {
                    this.tabPane_.addTab("-", this.icon_, null);
                    continue;
                }
                this.tabPane_.remove(this.tabPane_.getTabCount() - 1);
            }
            Iterator it = this.diagrams_.iterator();
            int i = 0;
            while (it.hasNext()) {
                Diagram diagram = (Diagram)it.next();
                this.tabPane_.setTitleAt(i++, diagram.getName());
            }
            int lastIndex = -1;
            if (lastTitle != null) {
                lastIndex = GuiHelper.getTabIndex(this.tabPane_, lastTitle);
            }
            if (lastIndex > -1) {
                this.tabPane_.setSelectedIndex(lastIndex);
                showDiagram = this.diagramSrv_.getDiagram(lastTitle);
            } else {
                showDiagram = (Diagram)this.diagrams_.get(0);
                this.tabPane_.setComponentAt(0, this.scrollPane_);
            }
        } else {
            this.tabPane_.removeAll();
            this.tabPane_.addTab("-", this.icon_, this.scrollPane_);
        }
        this.zmCtrlMgr_.refreshCtrls();
        this.setDiagram(showDiagram);
        this.addTabPaneChangeListener();
    }

    public void setDiagram(Diagram diagram) {
        if (diagram != null) {
            Diagram oldDiagram = this.diagramPanel_.getDiagram();
            if (oldDiagram != null) {
                if (!oldDiagram.getName().equals(diagram.getName())) {
                    if (this.cmdChain_ == null) {
                        LogUtil.logMsg("DiagramTabPan.cmdChain NULL!!");
                    }
                    ChangePanelDiagram cmd = new ChangePanelDiagram(this, oldDiagram, diagram);
                    cmd.setCommandChain(this.cmdChain_);
                    cmd.actionPerformed(new ActionEvent(this, 0, ""));
                }
            } else {
                this.changeDiagram(diagram);
            }
        } else {
            this.changeDiagram(diagram);
        }
    }

    public void changeDiagram(Diagram diagram) {
        int index;
        Diagram oldDiagram = this.diagramPanel_.getDiagram();
        if (oldDiagram != null) {
            oldDiagram.removeObserver(this);
        }
        if (diagram != null && (index = GuiHelper.getTabIndex(this.tabPane_, diagram.getName())) != this.tabPane_.getSelectedIndex()) {
            this.tabPane_.removeChangeListener(this.lisTabChange_);
            this.tabPane_.setSelectedIndex(index);
            this.addTabPaneChangeListener();
        }
        this.diagramPanel_.setDiagram(diagram);
        Point pt = new Point();
        this.viewportMoveCtrl_.moveViewDirectly(pt);
        this.updateZoomToolbar();
        this.updateNavigatorDiagram(diagram);
    }

    private void updateNavigatorDiagram(Diagram newDiagram) {
        if (this.navigator_ != null) {
            this.navigator_.setDiagram(newDiagram);
            this.updateNavigatorPortal();
        }
    }

    private void updateNavigatorPortal() {
        if (this.navigator_ != null) {
            this.navigator_.setPortalInDiaCoords(this.getPortal());
        }
    }

    @Override
    public Rectangle2D getPortal() {
        Rectangle vpRect = this.scrollPane_.getViewport().getViewRect();
        Rectangle2D.Double vpRect2D = new Rectangle2D.Double(vpRect.getX(), vpRect.getY(), vpRect.getWidth(), vpRect.getHeight());
        return vpRect2D;
    }

    private void addTabPaneChangeListener() {
        boolean alreadyAdded = false;
        ChangeListener[] listeners = this.tabPane_.getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ChangeListener listener = listeners[i];
            if (!listener.equals(this.lisTabChange_)) continue;
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            this.tabPane_.addChangeListener(this.lisTabChange_);
        }
    }

    private void updateDiagramViewPosition() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            Point pt = this.scrollPane_.getViewport().getViewPosition();
            if (this.updateNvFlag_) {
                this.updateNavigatorPortal();
            }
            this.zmCtrlMgr_.clearIdealRect(diagram);
        }
    }

    private void setScrollIncrements() {
        this.vbar_.setUnitIncrement(10);
        this.hbar_.setUnitIncrement(10);
    }

    public void setDragSource(IDragSource source) {
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        Diagram currentDiagram = this.diagramPanel_.getDiagram();
        if (chain.hasInteface(Glyph.class.getName())) {
            this.notifyObservers(chain);
        }
        if (chain.hasInteface(IDiagramSrv.class.getName())) {
            if (currentDiagram != null) {
                currentDiagram.setNeedRender(true);
                this.diagramPanel_.refresh();
            }
            if (chain.hasClassName(Diagram.getClassName())) {
                this.checkNewDiagram();
            }
        }
        if (this.navigator_ != null && chain.hasInteface(INavigator.class.getName())) {
            Dimension size;
            this.updateNvFlag_ = false;
            Rectangle2D portal = this.navigator_.getPortalInDiaCoords();
            Point pt = new Point(MathUtil.round(portal.getX()), MathUtil.round(portal.getY()));
            ITestResult result = this.viewportMoveCtrl_.checkMoveOk(pt, size = this.diagramPanel_.getPreferredSize());
            if (result.getPassed()) {
                this.viewportMoveCtrl_.moveViewDirectly(pt);
            }
            this.updateNvFlag_ = true;
        }
        if (this.navigator_ != null && chain.hasClassName(ViewportMoveCtrl.class.getName())) {
            this.updateNavigatorPortal();
        }
    }

    private void checkNewDiagram() {
        ArrayList<String> currentNames = new ArrayList<String>();
        ArrayList<String> newNames = new ArrayList<String>();
        int tabCount = this.tabPane_.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            currentNames.add(this.tabPane_.getTitleAt(i));
        }
        for (Diagram diagram : this.diagramSrv_.getDiagrams()) {
            newNames.add(diagram.getName());
        }
        if (newNames.size() < currentNames.size()) {
            this.refresh();
        }
        newNames.removeAll(currentNames);
        if (newNames.size() > 0) {
            this.refresh();
            String newName = (String)newNames.get(0);
            this.changeDiagram(this.diagramSrv_.getDiagram(newName));
        }
    }

    private MouseEvent getTranslatedEvent(MouseEvent evt) {
        Point vpOrigin = this.scrollPane_.getViewport().getViewPosition();
        int newX = (int)((double)evt.getX() + vpOrigin.getX());
        int newY = (int)((double)evt.getY() + vpOrigin.getY());
        MouseEvent diagramEvt = new MouseEvent(this, evt.getID(), evt.getWhen(), evt.getModifiers(), newX, newY, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
        return diagramEvt;
    }

    private void slideDiagram(Point currentPt) {
        Diagram diagram = this.getDiagram();
        GuiHelper.setOpenHandCursor(this.scrollPane_);
        Rectangle2D diagramRect = diagram.getBounds2D();
        double dragX = this.slideStart_.getX() - currentPt.getX();
        double dragY = this.slideStart_.getY() - currentPt.getY();
        JViewport vp = this.scrollPane_.getViewport();
        Dimension vpSz = vp.getSize();
        Dimension viewSz = vp.getViewSize();
        double maxOriginX = viewSz.getWidth() - vpSz.getWidth();
        double newOriginX = this.preSlideOrigin_.getX() + dragX;
        if (newOriginX > maxOriginX) {
            newOriginX = maxOriginX;
        }
        if (newOriginX < 0.0) {
            newOriginX = 0.0;
        }
        double maxOriginY = viewSz.getHeight() - vpSz.getHeight();
        double newOriginY = this.preSlideOrigin_.getY() + dragY;
        if (newOriginY > maxOriginY) {
            newOriginY = maxOriginY;
        }
        if (newOriginY < 0.0) {
            newOriginY = 0.0;
        }
        Point newPt = new Point((int)newOriginX, (int)newOriginY);
        vp.setViewPosition(newPt);
    }

    private void clearSlide() {
        GuiHelper.setDefaultCursor(this.diagramPanel_);
        GuiHelper.setDefaultCursor(this.scrollPane_);
        this.slideStart_ = null;
        this.preSlideOrigin_ = null;
    }

    private void updateZoomToolbar() {
        if (this.zoomToolBar_ != null) {
            ArrayList<DiagramTabPanel> zoomables = new ArrayList<DiagramTabPanel>();
            zoomables.add(this);
            this.zoomToolBar_.setZoomables(zoomables);
        }
    }

    @Override
    public void setZoomToolbar(ZoomToolbar zoomToolBar) {
        this.zoomToolBar_ = zoomToolBar;
        this.updateZoomToolbar();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateDiagramViewPosition();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseDragged(this.getTranslatedEvent(mouseEvent));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point currentPt = mouseEvent.getPoint();
        boolean shift = mouseEvent.isShiftDown();
        Diagram diagram = this.getDiagram();
        if (this.slideStart_ != null && diagram != null && shift) {
            this.slideDiagram(currentPt);
        } else if (this.slideStart_ == null && shift) {
            this.slideStart_ = currentPt;
            this.preSlideOrigin_ = this.scrollPane_.getViewport().getViewPosition();
        } else {
            this.clearSlide();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseClicked(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseEntered(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseExited(this.getTranslatedEvent(mouseEvent));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.scrollPane_.requestFocusInWindow();
        this.diagramPanel_.mousePressed(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseReleased(this.getTranslatedEvent(mouseEvent));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean shift = keyEvent.isShiftDown();
        if (shift) {
            GuiHelper.setOpenHandCursor(this.diagramPanel_);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.clearSlide();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.updateNavigatorPortal();
    }

    @Override
    public Zoom getZoom() {
        if (this.getDiagram() != null) {
            return new Zoom(this.getDiagram().getZoom().getLevel());
        }
        return new Zoom(1.0);
    }

    @Override
    public void setZoom(Zoom zoom) {
        if (this.getDiagram() != null) {
            Diagram diagram = this.getDiagram();
            double newZmLevel = zoom.getLevel();
            Rectangle vpRect = this.scrollPane_.getViewport().getViewRect();
            Rectangle2D.Double rect2D = new Rectangle2D.Double(vpRect.getX(), vpRect.getY(), vpRect.getWidth(), vpRect.getHeight());
            Rectangle2D newRect = this.zmCtrlMgr_.getZoomedRect(this.getDiagram(), newZmLevel, rect2D);
            Point rawOrigin = new Point((int)newRect.getX(), (int)newRect.getY());
            this.diagramPanel_.drawBlank();
            this.diagramPanel_.refresh();
            this.zmCtrlMgr_.setZoomingInProgress(this.getDiagram(), true);
            diagram.setSuppressPaint(true);
            diagram.setZoom(zoom);
            this.viewportMoveCtrl_.moveViewDirectly(rawOrigin);
            diagram.setSuppressPaint(false);
            this.zmCtrlMgr_.setZoomingInProgress(this.getDiagram(), false);
        }
    }
}

