/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandPopup;
import com.harrand.coregui.command.DbwCommandFactory;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.table.PromptTableDetails;
import com.harrand.sketch.command.IDeleteGlyphsCmdFactory;
import com.harrand.sketch.command.IDiagramCmdBldr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.Lasso;
import com.harrand.sketch.glyph.AnchorGlyph;
import com.harrand.sketch.glyph.interfaces.IAnchorGlyphStore;
import com.harrand.sketch.glyph.mgr.GlyphSelectionMgr;
import com.harrand.sketch.interfaces.IDiagramContainer;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import com.harrand.sketch.interfaces.INavigatorSrc;
import com.harrand.sketch.j2d.DiagramKeyListener;
import com.harrand.sketch.j2d.SelectedGlyphBlinker;
import com.harrand.sketch.j2d.draw.DiagramDrawer;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.sketch.j2d.mouse.DiagramMouseCtrl;
import com.harrand.sketch.panel.diagram.IDiagramPanel;
import com.harrand.sketch.relation.line.LineLinkPair;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.mouse.DiagramLineTracker;
import com.harrand.sketch.text.textLine.SimpleTextLine;
import com.harrand.sketch.text.watermark.textEngine.IWatermarkTextEngine;
import com.harrand.util.LogUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class DiagramPanel
extends JPanel
implements MouseListener,
IObserver,
IObservable,
DropTargetListener,
IDiagramPanel {
    private Diagram diagram;
    private Graphics2D g2;
    private final IDrawableOrderer drawableOrderer;
    private final DiagramDrawer diagramDrawer;
    private DiagramLineTracker diagramLineTracker;
    private IDiagramCmdBldr diagramCmdBldr_;
    private IDeleteGlyphsCmdFactory deleteGlyphsCmdfactory_;
    private IDiagramContainer diagramContainer_ = null;
    private IAnchorGlyphStore anchorGlyphStore;
    private CommandPopup popup_;
    private JPanel propertyPanel_;
    private final JPanel emptyPropPanel_ = new JPanel();
    private BasicObservable observable_;
    private INavigatorSrc nvSrc_;
    private ActionListener lisCancelDrag_;
    private ActionListener lisDeleteSelected_;
    private ActionListener lisSelectAll_;
    private ActionListener lisZoomIn_;
    private final float[] dashes_ = new float[]{4.0f, 2.0f};
    private final BasicStroke lassoStroke_ = new BasicStroke(1.0f, 0, 1, 0.0f, this.dashes_, 0.0f);
    private SwingThemeCtrl themeCtrl_;
    private BufferedImage diagramImg_;
    private Dimension diagramPreferredSize_;
    private Rectangle2D watermarkRect_;
    private AnchorGlyph lastHoverAnchor_;
    private IWatermarkTextEngine watermark;
    private int frameCount;
    public static final int BUF_IMG_MARGIN = 200;
    public static final int VIEWPORT_MARGIN = 200;
    public static final int WATERMARK_HEIGHT = 400;
    public static final int WATERMARK_WIDTH = 600;
    private static final boolean DO_BENCHMARKING = false;
    private long startMS;
    private IDiagramPlugin diagramPlugin;

    public DiagramPanel(Diagram diagram, IDrawableOrderer drawableOrderer) {
        this.diagram = diagram;
        this.drawableOrderer = drawableOrderer;
        this.diagramDrawer = new DiagramDrawer(this.drawableOrderer);
        this.init();
    }

    private Point getDiagramPt(MouseEvent e) {
        return this.diagram.getDiagramPt(e.getPoint());
    }

    private void init() {
        this.observable_ = new BasicObservable();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        if (this.drawableOrderer instanceof IAnchorGlyphStore) {
            this.anchorGlyphStore = (IAnchorGlyphStore)((Object)this.drawableOrderer);
        }
        this.setOpaque(true);
        this.watermarkRect_ = new Rectangle2D.Double(0.0, 0.0, 600.0, 400.0);
        this.diagramLineTracker = new DiagramLineTracker(this.diagram);
        this.diagram.setDiagramPanel(this);
        this.setBackground(Color.WHITE);
        this.addListeners();
    }

    public void setDiagramCmdBldr(IDiagramCmdBldr diagramCmdBldr) {
        this.diagramCmdBldr_ = diagramCmdBldr;
    }

    public void setDiagramContainer(IDiagramContainer container) {
        this.diagramContainer_ = container;
    }

    public void setPlugin(IDiagramPlugin diagramPlugin) {
        this.diagramPlugin = diagramPlugin;
        this.drawableOrderer.setDiagramPlugin(this.diagramPlugin);
    }

    @Override
    public IDiagramPlugin getPlugin() {
        return this.diagramPlugin;
    }

    public void setDeleteGlyphsCmdFactory(IDeleteGlyphsCmdFactory factory) {
        this.deleteGlyphsCmdfactory_ = factory;
        if (this.isDiagramSet()) {
            this.diagram.setDeleteGlyphsCmdFactory(this.deleteGlyphsCmdfactory_);
        }
    }

    public void setNavigatorSrc(INavigatorSrc nvSrc) {
        this.nvSrc_ = nvSrc;
    }

    @Override
    public String toString() {
        String diagramName = this.isDiagramSet() ? this.diagram.getName() : "No Diagram";
        return this.clazz() + ": " + diagramName;
    }

    public String clazz() {
        return "DiagramPanel";
    }

    public void setDropTargetListener(DropTargetListener dropLis) {
        new DropTarget(this, 3, dropLis);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.diagram.getSuppressPaint()) {
            super.paintComponent(g);
            this.drawBlank();
        } else {
            super.paintComponent(g);
            this.paintGuts(g);
        }
    }

    public IWatermarkTextEngine getWatermark() {
        return this.watermark;
    }

    public void setWatermark(IWatermarkTextEngine watermark) {
        this.watermark = watermark;
    }

    private boolean isDiagramSet() {
        return this.diagram != null;
    }

    private void paintGuts(Graphics g) {
        if (this.isDiagramSet()) {
            int glyphCount = this.diagram.getOnlyGlyphs().size();
            if (glyphCount > 0) {
                this.g2 = (Graphics2D)g;
                this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.diagramDrawer.draw(this.g2, this.diagram);
                this.drawLasso();
                this.notifyObservers(null);
            } else {
                this.drawWatermark(g);
            }
        } else {
            LogUtil.logErr("DiagramPanel.No Diagram set");
        }
    }

    private void updateDiagramPreferredSize() {
        Rectangle2D rect = this.isDiagramSet() ? this.diagram.getBounds2D() : this.watermarkRect_;
        this.diagramPreferredSize_ = new Dimension((int)rect.getWidth() + 200, (int)rect.getHeight() + 200);
    }

    private void updateZoomPreferredSize() {
        double zoomLevel = 1.0;
        Rectangle2D rect = this.watermarkRect_;
        if (this.isDiagramSet()) {
            zoomLevel = this.diagram.getZoom().getLevel();
            rect = Zoomer.zoom(this.diagram.getBounds2D(), zoomLevel);
        }
    }

    private void drawWatermark(Graphics g) {
        if (this.isWatermarkSet()) {
            this.g2 = (Graphics2D)g;
            this.setBackColor(Color.WHITE);
            Paint oldPaint = this.g2.getPaint();
            this.g2.setPaint(Colors.getBlueGreenMild());
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2.setFont(new Font("Dialog", 1, 24));
            this.g2.drawString(this.watermark.getTitle(), 160, 40);
            this.g2.setFont(new Font("Dialog", 1, 12));
            int y = 70;
            for (SimpleTextLine line : this.watermark.getTextLines()) {
                Point pt = line.getOrigin();
                this.g2.drawString(line.getText(), pt.x, y);
                y += 20;
            }
            this.g2.setPaint(oldPaint);
        }
    }

    public void drawBlank() {
        this.setBackColor(Color.WHITE);
    }

    public void deleteSelected() {
        LogUtil.logMsg(this, "delete hit");
        this.diagram.deleteSelected();
    }

    private void addListeners() {
        this.lisCancelDrag_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramPanel.this.diagram.cancelDrag();
            }
        };
        this.lisDeleteSelected_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramPanel.this.deleteSelected();
            }
        };
        this.lisSelectAll_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramPanel.this.diagram.selectAllGlyphs();
                DiagramPanel.this.refresh();
            }
        };
        this.lisZoomIn_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramPanel.this.executeZoomCmd(1);
            }
        };
        this.addKeyListener(new DiagramKeyListener(this));
        this.registerKeyboardAction(this.lisCancelDrag_, KeyStroke.getKeyStroke(27, 0, false), 2);
        this.registerKeyboardAction(this.lisDeleteSelected_, KeyStroke.getKeyStroke(127, 128, false), 2);
        this.registerKeyboardAction(this.lisDeleteSelected_, KeyStroke.getKeyStroke(127, 128, false), 2);
        this.registerKeyboardAction(this.lisSelectAll_, KeyStroke.getKeyStroke(65, 128, false), 2);
        this.registerKeyboardAction(this.lisZoomIn_, KeyStroke.getKeyStroke(61, 128, false), 2);
    }

    private void executeZoomCmd(int direction) {
        if (this.diagramContainer_ != null) {
            this.diagramContainer_.doZoom(direction);
        } else {
            LogUtil.logErr("DiagramPanel.diagramContainer not set!");
        }
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    @Deprecated
    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        if (this.isDiagramSet()) {
            diagram.setDiagramPanel(this);
            this.updateDiagramPreferredSize();
            this.updateZoomPreferredSize();
        }
        if (this.diagramCmdBldr_ != null) {
            this.diagramCmdBldr_.setDiagram(diagram);
        }
        this.propertyPanel_ = this.emptyPropPanel_;
        this.themeCtrl_.process(this.propertyPanel_);
        if (diagram != null) {
            diagram.addObserver(this);
            diagram.setNeedRender(true);
            diagram.setDeleteGlyphsCmdFactory(this.deleteGlyphsCmdfactory_);
        }
        this.refresh();
    }

    public void close() {
        this.diagramImg_ = null;
    }

    public BufferedImage getDiagramImg() {
        return this.diagramImg_;
    }

    public JPanel getPropertyPanel() {
        return this.propertyPanel_;
    }

    @Override
    public void refresh() {
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void setBackColor(Color color) {
        Rectangle bounds = this.getBounds();
        Paint oldPaint = this.g2.getPaint();
        this.g2.setPaint(color);
        this.g2.fill(bounds);
        this.g2.setPaint(oldPaint);
    }

    @Override
    public Dimension getPreferredSize() {
        this.updateDiagramPreferredSize();
        double zoomLevel = this.isDiagramSet() ? this.diagram.getZoom().getLevel() : 1.0;
        Dimension preferredSize = new Dimension((int)(zoomLevel * (double)this.diagramPreferredSize_.width), (int)(zoomLevel * (double)this.diagramPreferredSize_.height));
        return preferredSize;
    }

    private void drawLasso() {
        Lasso lasso = this.diagram.getLasso();
        if (lasso != null) {
            Stroke oldStroke = this.g2.getStroke();
            this.g2.setStroke(this.lassoStroke_);
            this.g2.draw(lasso.getBounds());
            this.g2.setStroke(oldStroke);
        }
    }

    public void blinkSelectedGlyphs() {
        SelectedGlyphBlinker blinker = new SelectedGlyphBlinker(this, this.diagram);
        blinker.doBlinks();
    }

    public void checkPropertyPanel(Point p) {
        Glyph glyph = this.diagram.getGlyphContainingPoint(p);
        if (glyph != null) {
            this.updateLookup();
        }
    }

    private void updateLookup() {
        List glyphNms = this.getGlyphSelectionMgr().getSelectedGlyphNms(true);
        int glyphCount = glyphNms.size();
        if (glyphCount == 1) {
            String selectedNm = (String)glyphNms.get(0);
            Glyph glyph = this.diagram.getGlyphOrLink(selectedNm);
            CentralLookup.getDefault().addOrReplace(glyph, Glyph.class);
        }
    }

    private GlyphSelectionMgr getGlyphSelectionMgr() {
        return this.diagram.getSelectionMgr();
    }

    private DiagramMouseCtrl getDiagramMouseCtrl() {
        return this.diagram.getMouseCtrl();
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
        this.notifyObservers(chain);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isDiagramSet()) {
            this.getDiagramMouseCtrl().mouseDown(e);
            this.requestFocus();
            this.refresh();
            this.checkPropertyPanel(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDiagramSet() && !this.showedPopup(e)) {
            this.diagram.mouseUp(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isDiagramSet()) {
            this.diagram.setDiagramPanel(this);
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.diagram.mouseDragged(e);
                this.checkDragCursor(e);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.checkResizeCursor(e)) {
            this.setDefaultCursor();
        }
        this.diagram.mouseMoved(e);
    }

    private void checkDragCursor(MouseEvent e) {
        boolean noLasso = this.diagram.getLasso() == null;
        boolean isResizing = this.diagram.isResizing();
        if (noLasso) {
            if (this.hasLastHoverAnchor() && isResizing) {
                this.lastHoverAnchor_.setCursor(this);
            } else {
                boolean lineMoveCursor = this.checkLinkMoveCursor(e);
                if (!lineMoveCursor) {
                    this.setCursor(GuiHelper.CURSOR_MOVE);
                }
            }
        }
    }

    private boolean hasLastHoverAnchor() {
        return this.lastHoverAnchor_ != null;
    }

    private boolean checkResizeCursor(MouseEvent e) {
        if (this.checkLinkMoveCursor(e)) {
            return true;
        }
        if (this.anchorGlyphStore == null) {
            return false;
        }
        boolean isOverAnchor = false;
        Point pt = this.getDiagramPt(e);
        for (AnchorGlyph anchor : this.anchorGlyphStore.getAnchorGlyphs()) {
            if (!anchor.contains(pt)) continue;
            this.lastHoverAnchor_ = anchor;
            this.lastHoverAnchor_.setCursor(this);
            isOverAnchor = true;
        }
        return isOverAnchor;
    }

    private boolean checkLinkMoveCursor(MouseEvent e) {
        Line2D containingLine;
        Point mousePoint;
        LineLinkPair lineLinkPair;
        boolean areLinksMovable = this.diagram.getRenderConfig().getLinkStrategy().getAreLinksMovable();
        if (areLinksMovable && (lineLinkPair = this.diagramLineTracker.getContainingLine(mousePoint = e.getPoint())) != null && (containingLine = lineLinkPair.getLine()) instanceof PositionableLine) {
            PositionableLine positionableLine = (PositionableLine)containingLine;
            Cursor cursor = positionableLine.isVerticalLine() ? GuiHelper.CURSOR_E_RESIZE : GuiHelper.CURSOR_N_RESIZE;
            this.setCursor(cursor);
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this);
    }

    private boolean showedPopup(MouseEvent e) {
        int btnHit = e.getButton();
        boolean alt = e.isAltDown();
        boolean show = btnHit == 1 && alt;
        show = show || btnHit == 3;
        boolean bl = show = show || btnHit == 2;
        if (show) {
            this.showPopup(e);
            return true;
        }
        if (e.getClickCount() == 2) {
            Table table = this.diagram.getSelectedTable();
            if (table != null) {
                PromptTableDetails command = new PromptTableDetails(table);
                command.actionPerformed(null);
                return true;
            }
            ForeignKey fk = this.diagram.getSelectedForeignKey();
            if (fk != null) {
                Database db = LookupUtil.getLookupDb();
                Command command = DbwCommandFactory.getEditFkCmd(db, fk.getParTbl(), fk);
                command.actionPerformed(null);
                return true;
            }
        }
        return false;
    }

    private void showPopup(MouseEvent e) {
        if (this.diagramCmdBldr_ == null) {
            return;
        }
        ArrayList list = new ArrayList();
        Point p = e.getPoint();
        this.diagramCmdBldr_.setDiagram(this.getDiagram());
        list.addAll(this.diagramCmdBldr_.getCommands(p));
        this.popup_ = new CommandPopup(list);
        int offsetX = 0;
        int offsetY = 0;
        if (this.nvSrc_ != null) {
            Rectangle2D portal = this.nvSrc_.getPortal();
            offsetX = (int)portal.getX();
            offsetY = (int)portal.getY();
        }
        this.popup_.show(e.getComponent(), e.getX() - offsetX, e.getY() - offsetY);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private boolean isWatermarkSet() {
        return this.watermark != null;
    }
}

