/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph.rect.fill;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.glyph.rect.IFontDependentRectangleFill;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class HeaderFooterFill
implements IRectangleFill,
IFontDependentRectangleFill {
    private static final double DEFAULT_HEADER_HEIGHT = 24.0;
    private static final double FOOTER_LINE_HEIGHT_FACTOR = 0.5;
    private final Color BACKGROUND_RECT_COLOR = Color.WHITE;
    public static final String NAME = "HeaderFooterFill";
    public static final String DESC_NM = "Header Gradient Fill";
    private Graphics2D g2;
    private RoundRectangle2D roundRect;
    private Color color;
    private double radius;
    private double width;
    private double x;
    private double headerHeight = 24.0;

    @Override
    public void fill(Graphics2D g2, RoundRectangle2D roundRect, Color color, boolean useGradient) {
        this.roundRect = roundRect;
        this.color = color;
        this.g2 = g2;
        this.doCalcs();
        Paint oldPaint = g2.getPaint();
        Paint paint = color;
        if (useGradient) {
            paint = GuiHelper.getGradientPaint(roundRect.getBounds(), color);
        }
        g2.setPaint(paint);
        g2.fill(this.getHeaderRect());
        g2.fill(this.getFooterRect());
        this.drawBackgroundRect();
        g2.setPaint(oldPaint);
    }

    @Override
    public void setHeaderHeight(double headerHeight) {
        this.headerHeight = headerHeight;
    }

    @Override
    public List<EnhancedShape> getFillEShapes(RoundRectangle2D roundRect, Color color, boolean useGradient, Point coordSpace) {
        this.roundRect = roundRect;
        this.color = color;
        this.doCalcs();
        RoundRectangle2D headerRect = this.getHeaderRect();
        RoundRectangle2D footerRect = this.getFooterRect();
        Rectangle2D backgroundRect = this.getBackgroundRect();
        if (coordSpace != null) {
            headerRect = GeometryHelper.move(headerRect, coordSpace);
            footerRect = GeometryHelper.move(footerRect, coordSpace);
            backgroundRect = GeometryHelper.move(backgroundRect, coordSpace);
        }
        ArrayList<EnhancedShape> eShapes = new ArrayList<EnhancedShape>();
        eShapes.add(new EnhancedShape(headerRect, color, true));
        eShapes.add(new EnhancedShape(footerRect, color, true));
        eShapes.add(new EnhancedShape(backgroundRect, this.BACKGROUND_RECT_COLOR, false));
        return eShapes;
    }

    private double getFooterHeight() {
        double footerHeight = 0.5 * this.headerHeight;
        return footerHeight;
    }

    private double getHeaderHeight() {
        return this.headerHeight;
    }

    private RoundRectangle2D getFooterRect() {
        double y = this.roundRect.getY() + this.roundRect.getHeight() - this.getFooterHeight();
        RoundRectangle2D.Double footerRect = new RoundRectangle2D.Double(this.x, y, this.width, this.getFooterHeight(), this.radius, this.radius);
        return footerRect;
    }

    private RoundRectangle2D getHeaderRect() {
        double y = this.roundRect.getY();
        RoundRectangle2D.Double headerRect = new RoundRectangle2D.Double(this.x, y, this.width, this.getHeaderHeight(), this.radius, this.radius);
        return headerRect;
    }

    private Rectangle2D getBackgroundRect() {
        double topOffset = this.getHeaderHeight() - this.radius;
        double y = this.roundRect.getY() + topOffset;
        double height = this.roundRect.getHeight() - this.getHeaderHeight() - this.getFooterHeight() + 2.0 * this.radius;
        Rectangle2D.Double rect = new Rectangle2D.Double(this.x, y, this.width, height);
        return rect;
    }

    private void doCalcs() {
        this.x = this.roundRect.getX();
        this.width = this.roundRect.getWidth();
        this.radius = this.roundRect.getArcHeight();
    }

    private void drawBackgroundRect() {
        this.g2.setPaint(this.BACKGROUND_RECT_COLOR);
        this.g2.fill(this.getBackgroundRect());
        this.g2.setPaint(this.color);
    }

    public String toString() {
        return DESC_NM;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elm = XmlHelper.createElementSimple(doc, "DbTableRectangleFill", this.getName());
        return elm;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setName(String newName) {
    }
}

