/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph.rect.fill;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BasicRectangleFill
implements IRectangleFill {
    public static final String NAME = "BasicRectangleFill";
    public static final String DESC_NM = "Full Gradient Fill";

    @Override
    public void fill(Graphics2D g2, RoundRectangle2D roundRect, Color color, boolean useGradient) {
        Paint paint = color;
        if (useGradient) {
            paint = GuiHelper.getGradientPaint(roundRect.getBounds(), color);
        }
        g2.setPaint(paint);
        g2.fill(roundRect);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elm = XmlHelper.createElementSimple(doc, "DbTableRectangleFill", this.getName());
        return elm;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setName(String newName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return DESC_NM;
    }

    @Override
    public List<EnhancedShape> getFillEShapes(RoundRectangle2D roundRect, Color color, boolean useGradient, Point coordSpace) {
        RoundRectangle2D rectOut = roundRect;
        if (coordSpace != null) {
            rectOut = GeometryHelper.move(roundRect, coordSpace);
        }
        ArrayList<EnhancedShape> eShapes = new ArrayList<EnhancedShape>();
        eShapes.add(new EnhancedShape(rectOut, color));
        return eShapes;
    }

    @Override
    public void setHeaderHeight(double fontLineHeight) {
    }
}

