/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph.mouse;

import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.ctrl.IClickActionCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.calc.DiagramHasGlyphCalc;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BasicGlyphMouseTracker
implements IMouseTracker {
    private IClickActionCtrl clickActionCtrl;
    private IRefreshable refreshable;
    private Glyph glyph;
    private Diagram diagram;
    private Identifiable idf;

    public BasicGlyphMouseTracker(IClickActionCtrl clickActionCtrl, Glyph glyph, IRefreshable refreshable, Diagram diagram, Identifiable idf) {
        this.clickActionCtrl = clickActionCtrl;
        this.glyph = glyph;
        this.refreshable = refreshable;
        this.diagram = diagram;
        this.idf = idf;
    }

    public boolean containsZoomed(Point2D p) {
        return this.getZoomedBounds().contains(p);
    }

    private void refreshDisp(MouseEvent e) {
        this.clickActionCtrl.refresh();
        for (IClickAction clickAction : this.clickActionCtrl.getClickActions()) {
            clickAction.mouseMoved(e.getPoint());
        }
        this.refreshable.refresh();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isOverGlyph = this.containsZoomed(e.getPoint());
        this.clickActionCtrl.setIsActive(isOverGlyph);
        if (isOverGlyph) {
            this.refreshDisp(e);
        } else {
            this.clickActionCtrl.checkClearClickActions();
        }
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        boolean isOverGlyph = this.containsZoomed(e.getPoint());
        boolean processed = false;
        if (isOverGlyph) {
            boolean stillInDiagram;
            processed = this.clickActionCtrl.mouseDown(e);
            boolean idfStillInDiagram = this.diagram.contains(this.idf.getMapName(), this.idf.getName());
            boolean glyphStillInDiagram = new DiagramHasGlyphCalc().hasGlyph(this.diagram, this.glyph);
            boolean bl = stillInDiagram = idfStillInDiagram || glyphStillInDiagram;
            if (processed && stillInDiagram) {
                this.clickActionCtrl.checkClearClickActions();
                this.mouseMoved(e);
            }
        }
        return processed;
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.refreshDisp(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clickActionCtrl.checkClearClickActions();
    }

    public Rectangle2D getZoomedBounds() {
        return Zoomer.zoom(this.getBounds(), this.getZoomLevel());
    }

    private Rectangle2D getBounds() {
        return this.glyph.getBounds2D();
    }

    private double getZoomLevel() {
        return this.diagram.getRenderConfig().getZoomLevel();
    }
}

