/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph.mgr;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.command.IDeleteGlyphsCmdFactory;
import com.harrand.sketch.command.RemoveGlyphs;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.mgr.IGlyphSrc;
import com.harrand.sketch.interfaces.IObjGlyph;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public final class GlyphSelectionMgr {
    private CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
    private IDeleteGlyphsCmdFactory deleteGlyphsCmdfactory_;
    private IGlyphSrc glyphSrc;

    public GlyphSelectionMgr(IGlyphSrc glyphSrc) {
        this.glyphSrc = glyphSrc;
    }

    public List getSelectedGlyphNms(boolean includeLinks) {
        ArrayList<String> selectedNms = new ArrayList<String>();
        for (Glyph glyph : this.getGlyphs(includeLinks)) {
            if (!glyph.getSelected()) continue;
            selectedNms.add(glyph.getName());
        }
        return selectedNms;
    }

    public boolean hasSelectedGlyphs(boolean includeLinks) {
        return this.getSelectedGlyphs(includeLinks).size() > 0;
    }

    public List<Glyph> getSelectedGlyphs(boolean includeLinks) {
        ArrayList<Glyph> selectedGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.getGlyphs(includeLinks)) {
            if (!glyph.getSelected()) continue;
            selectedGlyphs.add(glyph);
        }
        return selectedGlyphs;
    }

    public DbTableGlyph getSelectedDbTableGlyph() {
        Glyph selected;
        List<Glyph> glyphs = this.getSelectedGlyphs(false);
        if (glyphs.size() == 1 && (selected = glyphs.get(0)) instanceof DbTableGlyph) {
            return (DbTableGlyph)selected;
        }
        return null;
    }

    public Table getSelectedTable() {
        DbTableGlyph selected = this.getSelectedDbTableGlyph();
        if (selected != null) {
            return selected.getTable();
        }
        return null;
    }

    public ForeignKey getSelectedForeignKey() {
        ForeignKeyGlyph glyph = this.getSelectedForeignKeyGlyph();
        if (glyph != null) {
            return glyph.getForeignKey();
        }
        return null;
    }

    public ForeignKeyGlyph getSelectedForeignKeyGlyph() {
        Glyph selected;
        List<Glyph> glyphs = this.getSelectedGlyphs(true);
        if (glyphs.size() == 1 && (selected = glyphs.get(0)) instanceof ForeignKeyGlyph) {
            return (ForeignKeyGlyph)selected;
        }
        return null;
    }

    public void addGlyphToSelection(Glyph glyph) {
        List<Glyph> selectedGlyphs = this.getSelectedGlyphs(true);
        selectedGlyphs.add(glyph);
        this.setSelectedGlyphs2(selectedGlyphs);
    }

    public void setSelectedGlyph(String glyphNm) {
        ArrayList<String> selGlyphNms = new ArrayList<String>();
        selGlyphNms.add(glyphNm);
        this.setSelectedGlyphs(selGlyphNms);
    }

    public void setSelectedGlyphs(List glyphNms) {
        this.unselectGlyphs();
        Glyph lastGlyph = null;
        for (Glyph glyph : this.getGlyphs(true)) {
            if (!glyphNms.contains(glyph.getName())) continue;
            glyph.setSelected(true);
            lastGlyph = glyph;
        }
        this.postGlyphToLookup(lastGlyph);
    }

    public void selectAllGlyphs() {
        this.setSelectedGlyphs2(this.getGlyphs(false));
    }

    public void setSelectedGlyphs2(List<Glyph> glyphs) {
        ArrayList<String> selGlyphNms = new ArrayList<String>();
        for (Glyph glyph : glyphs) {
            selGlyphNms.add(glyph.getName());
        }
        this.setSelectedGlyphs(selGlyphNms);
    }

    public void unselectGlyphs() {
        boolean hadSelected = false;
        List<Glyph> glyphs = this.getGlyphs(true);
        for (Glyph glyph : glyphs) {
            if (!hadSelected && glyph.getSelected()) {
                hadSelected = true;
            }
            glyph.setSelected(false);
        }
    }

    public void deleteSelected() {
        ArrayList<Glyph> selectedGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.getSelectedGlyphs(true)) {
            selectedGlyphs.add(glyph);
        }
        Command deleteCmd = null;
        if (this.deleteGlyphsCmdfactory_ != null) {
            deleteCmd = this.deleteGlyphsCmdfactory_.getDeleteCmd((Diagram)this.glyphSrc, selectedGlyphs);
        } else {
            LogUtil.logErr("Diagram.DeleteGlyphsCmdFactory is null.");
            int state = Command.getStateDo();
            deleteCmd = new RemoveGlyphs((Diagram)this.glyphSrc, selectedGlyphs, state);
        }
        deleteCmd.setCommandChain(this.cmdChain);
        deleteCmd.actionPerformed(null);
    }

    public void setDeleteGlyphsCmdFactory(IDeleteGlyphsCmdFactory factory) {
        this.deleteGlyphsCmdfactory_ = factory;
    }

    private void postGlyphToLookup(Glyph glyph) {
        if (glyph != null) {
            CentralLookup.getDefault().addOrReplace(glyph, Glyph.class);
            if (glyph instanceof IObjGlyph) {
                IObjGlyph objGlyph = (IObjGlyph)((Object)glyph);
                Object obj = objGlyph.getGlyphObject();
                Class<?> clz = obj.getClass();
                CentralLookup.getDefault().addOrReplace(obj, clz);
            }
        }
    }

    private List<Glyph> getGlyphs(boolean includeLinks) {
        return this.glyphSrc.getGlyphs(includeLinks);
    }
}

