/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.glyph.footer.FooterGlyph;
import com.harrand.sketch.glyph.rect.fill.BasicRectangleFill;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.support.DrawableUtil;
import com.harrand.sketch.xml.svg.bldr.basic.SvgGradientBldr;
import com.harrand.sketch.xml.svg.bldr.glyph.SvgRectGroupBuilder;
import com.harrand.sketch.xml.svg.common.ISvgGradientable;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RectGlyph
implements ISvgShape,
ISvgGradientable,
IDrawable {
    public static final Color DEFAULT_STROKE_COLOR = Color.GRAY;
    private RoundRectangle2D rect_;
    private Color strokeColor = DEFAULT_STROKE_COLOR;
    private boolean useGradient_ = true;
    private Color bgColor_ = Color.WHITE;
    private Point coordSpace = new Point();
    private FooterGlyph footer;
    private IRectangleFill rectangleFill = new BasicRectangleFill();
    public static final String LINEAR_GRADIENT_ELM_NM = "linearGradient";

    public RectGlyph(RoundRectangle2D rect) {
        this.rect_ = rect;
    }

    public RectGlyph(Rectangle2D rect) {
        this(new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), 0.0, 0.0));
    }

    public void setHeaderHeight(double headerHeight) {
        this.rectangleFill.setHeaderHeight(headerHeight);
    }

    public void setBgColor(Color color) {
        this.bgColor_ = color;
    }

    public Color getColor() {
        return this.bgColor_;
    }

    public void setUseGradient(boolean flag) {
        this.useGradient_ = flag;
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public Point getCoordSpace() {
        return this.coordSpace;
    }

    public RoundRectangle2D getRect() {
        return this.rect_;
    }

    public void setFooter(FooterGlyph footer) {
        this.footer = footer;
    }

    private boolean hasFooter() {
        return this.footer != null;
    }

    public String toString() {
        return "RectGlyph: x: " + (int)this.rect_.getX() + ", y: " + (int)this.rect_.getY() + ", w:" + (int)this.rect_.getWidth() + ", h:" + (int)this.rect_.getHeight();
    }

    public void draw(Graphics2D g2) {
        Paint oldPaint = g2.getPaint();
        this.rectangleFill.fill(g2, this.rect_, this.bgColor_, this.useGradient_);
        g2.setPaint(oldPaint);
        if (this.hasFooter()) {
            DrawableUtil.drawMixedItems(this.footer.getShapes(), g2, new Zoom(1.0));
        }
        g2.setPaint(oldPaint);
        g2.setPaint(this.strokeColor);
        g2.draw(this.rect_);
        g2.setPaint(oldPaint);
    }

    private List<EnhancedShape> getEShapeRects() {
        List<EnhancedShape> fillShapes = this.rectangleFill.getFillEShapes(this.rect_, this.bgColor_, this.useGradient_, this.coordSpace);
        ArrayList<EnhancedShape> eShapesRects = new ArrayList<EnhancedShape>();
        eShapesRects.add(this.getMainRectEnhancedShape());
        eShapesRects.addAll(fillShapes);
        return eShapesRects;
    }

    private EnhancedShape getMainRectEnhancedShape() {
        EnhancedShape eShape = this.getMovedERect(this.rect_);
        eShape.setStrokeColor(this.strokeColor);
        eShape.setGradientPaint(this.bgColor_);
        return eShape;
    }

    private EnhancedShape getMovedERect(RoundRectangle2D roundedRect) {
        RoundRectangle2D absRect = GeometryHelper.move(roundedRect, this.coordSpace);
        EnhancedShape eShape = new EnhancedShape(absRect, this.getColor());
        return eShape;
    }

    @Override
    public Element getSvgElm(Document doc) {
        SvgRectGroupBuilder svgRectGroupBuilder = new SvgRectGroupBuilder();
        return svgRectGroupBuilder.getRectangleGroupElement(doc, this.getEShapeRects(), "RectGlyph", this.getGradientIdStr());
    }

    @Override
    public Element getGradientElm(Document doc) {
        if (this.useGradient_) {
            SvgGradientBldr elmBldr = new SvgGradientBldr(doc);
            return elmBldr.buildElm(Color.WHITE, this.bgColor_);
        }
        return null;
    }

    @Override
    public String getGradientIdStr() {
        if (this.useGradient_) {
            return StrHelper.getGradientIdString(Color.WHITE, this.bgColor_);
        }
        return null;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        this.draw(g2);
    }

    @Override
    public String getName() {
        return "rectGLyph";
    }

    @Override
    public void setName(String newName) {
    }

    public IRectangleFill getRectangleFill() {
        return this.rectangleFill;
    }

    public void setRectangleFill(IRectangleFill rectangleFill) {
        this.rectangleFill = rectangleFill;
    }
}

