/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.support.DrawableUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class AnchorGlyph
implements Glyph,
IPreImagedGlyph,
MouseMotionListener,
IDrawable {
    private String posStr_;
    private final Rectangle bounds_;
    public static final int LENGTH = 10;
    private static final double ENLARGEMENT_RATIO = 0.2;
    private boolean selected_;
    public static final String POS_NW = "NW";
    public static final String POS_N = "N";
    public static final String POS_NE = "NE";
    public static final String POS_E = "E";
    public static final String POS_SE = "SE";
    public static final String POS_S = "S";
    public static final String POS_SW = "SW";
    public static final String POS_W = "W";
    private final BufferedImage img_ = Icons.getBufferedImage("Anchor");

    public AnchorGlyph(Point center, String posStr) {
        int length = 10;
        this.posStr_ = posStr;
        int halfLength = (int)Math.round(0.5 * (double)length);
        Point origin = new Point(center.x - halfLength, center.y - halfLength);
        this.bounds_ = new Rectangle(origin, new Dimension(length, length));
    }

    public String getPosStr() {
        return this.posStr_;
    }

    public void setCursor(Component comp) {
        Cursor cursor = this.getCursor();
        comp.setCursor(cursor);
    }

    private Cursor getCursor() {
        if (this.posStr_.equals(POS_NW)) {
            return GuiHelper.CURSOR_NW_RESIZE;
        }
        if (this.posStr_.equals(POS_N)) {
            return GuiHelper.CURSOR_N_RESIZE;
        }
        if (this.posStr_.equals(POS_NE)) {
            return GuiHelper.CURSOR_NE_RESIZE;
        }
        if (this.posStr_.equals(POS_E)) {
            return GuiHelper.CURSOR_E_RESIZE;
        }
        if (this.posStr_.equals(POS_SE)) {
            return GuiHelper.CURSOR_SE_RESIZE;
        }
        if (this.posStr_.equals(POS_S)) {
            return GuiHelper.CURSOR_S_RESIZE;
        }
        if (this.posStr_.equals(POS_SW)) {
            return GuiHelper.CURSOR_SW_RESIZE;
        }
        if (this.posStr_.equals(POS_W)) {
            return GuiHelper.CURSOR_W_RESIZE;
        }
        return null;
    }

    @Override
    public BufferedImage getImage() {
        return this.img_;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds_.getBounds2D();
    }

    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public boolean contains(Point2D p) {
        Rectangle2D bounds = this.getBounds2D();
        double changeLength = 2.0;
        Rectangle2D.Double enlargedRect = new Rectangle2D.Double(bounds.getX() - 0.5 * changeLength, bounds.getY() - 0.5 * changeLength, 10.0 + changeLength, 10.0 + changeLength);
        return enlargedRect.contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    @Override
    public void setName(String newName) {
    }

    public ArrayList getDrawables() {
        return new ArrayList();
    }

    @Override
    public void move(Point p) {
    }

    @Override
    public String getName() {
        return "(AnchorGlyph - name not implemented)";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point mousePt = e.getPoint();
        if (this.bounds_.contains(mousePt)) {
            // empty if block
        }
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }
}

