/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.file.BasicFilePathSvr;
import com.harrand.coreclasses.file.BasicFileUseMgr;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coregui.command.CommandChain;
import com.harrand.sketch.core.BasicDiagramSvr;
import com.harrand.sketch.core.BasicLink;
import com.harrand.sketch.core.BasicLinkSource;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphBox;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;

public class TestData {
    public static final String DIAGRAM_A_NM = "Diagram A";
    public static final String DIAGRAM_B_NM = "Diagram B";
    public static final String LINK_AB_NM = "LinkAB";
    public static final String ZONE_A_NM = "zoneA";
    public static final String BOX_A_NM = "BoxA";
    public static final int BOX_A_X = 10;
    public static final int BOX_A_Y = 10;
    public static final int BOX_A_H = 50;
    public static final int BOX_A_W = 20;
    public static final String BOX_B_NM = "BoxB";
    public static final int BOX_B_X = 90;
    public static final int BOX_B_Y = 90;
    public static final int BOX_B_H = 40;
    public static final int BOX_B_W = 15;
    public static final String BOX_C_NM = "BoxC";
    public static final int BOX_C_X = 50;
    public static final int BOX_C_Y = 15;
    public static final int BOX_C_H = 50;
    public static final int BOX_C_W = 20;
    public static final String PNG_PATH = "home/usr/dbwrench files/pngs";
    public static final String JPEG_PATH = "home/usr/dbwrench files/jpegs";
    public static final File PNG_RECENT_A = new File("/home/usr/dbwrench/imageFiles/pngA.png");
    public static final File JPG_RECENT_A = new File("/home/usr/dbwrench/imageFiles/jpgA.jpg");
    public static final String SHOW_TYPE_KEY = "Type";
    public static final String SHOW_LENGTH_KEY = "Length";

    public static GlyphBox getGlyphBoxA() {
        Rectangle rect = new Rectangle(10, 10, 20, 50);
        GlyphBox box = new GlyphBox(rect, 0);
        box.setName(BOX_A_NM);
        return box;
    }

    public static GlyphBox getGlyphBoxB() {
        Rectangle rect = new Rectangle(90, 90, 15, 40);
        GlyphBox box = new GlyphBox(rect, 0);
        box.setName(BOX_B_NM);
        return box;
    }

    public static GlyphBox getGlyphBoxC() {
        Rectangle rect = new Rectangle(50, 15, 20, 50);
        GlyphBox box = new GlyphBox(rect, 0);
        box.setName(BOX_C_NM);
        return box;
    }

    public static Note getNoteA() {
        Note note = new Note("noteAText", new Point(310, 250));
        note.setColor(Color.RED);
        return note;
    }

    public static Zone getZoneA() {
        Rectangle bounds = new Rectangle(60, 40, 300, 200);
        Zone zone = new Zone(ZONE_A_NM, "zoneAText", bounds);
        zone.setColor(Color.GREEN);
        return zone;
    }

    public static Diagram getDiagramA() {
        ArrayList<GlyphBox> glyphs = new ArrayList<GlyphBox>();
        GlyphBox glyphA = TestData.getGlyphBoxA();
        GlyphBox glyphB = TestData.getGlyphBoxB();
        glyphs.add(glyphA);
        glyphs.add(glyphB);
        RenderConfig configA = new RenderConfig(1.0);
        Link link = TestData.getLinkAB(glyphA, glyphA);
        NamedList links = new NamedList();
        links.add((INamed)((Object)link));
        BasicLinkSource linkSource = new BasicLinkSource(links);
        Diagram diagram = new Diagram(DIAGRAM_A_NM, configA, glyphs);
        diagram.setLinkSource(linkSource);
        diagram.add(TestData.getNoteA());
        diagram.add(TestData.getZoneA());
        return diagram;
    }

    public static Diagram getDiagramAFont9() {
        Font font9 = new Font("Verdana", 0, 9);
        Diagram diagram = TestData.getDiagramA();
        diagram.getRenderConfig().setFont(font9);
        return diagram;
    }

    public static Font getFont9() {
        Font font = new Font("Verdana", 0, 9);
        return font;
    }

    public static Font getFont7() {
        Font font = new Font("Verdana", 0, 7);
        return font;
    }

    public static Diagram getDiagramB() {
        ArrayList<GlyphBox> glyphs = new ArrayList<GlyphBox>();
        glyphs.add(TestData.getGlyphBoxC());
        glyphs.add(TestData.getGlyphBoxB());
        RenderConfig configA = new RenderConfig(1.5);
        Diagram diagram = new Diagram(DIAGRAM_B_NM, configA, glyphs);
        return diagram;
    }

    public static Link getLinkAB(Glyph glyphA, Glyph glyphB) {
        BasicLink link = new BasicLink(LINK_AB_NM);
        NamedList glyphs = new NamedList();
        glyphs.add(glyphA);
        glyphs.add(glyphB);
        link.setBoxes(glyphs);
        return link;
    }

    public static BasicDiagramSvr getDiagramSvr() {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        diagrams.add(TestData.getDiagramA());
        diagrams.add(TestData.getDiagramB());
        BasicDiagramSvr svr = new BasicDiagramSvr(diagrams);
        return svr;
    }

    public static CommandChain getCommandChain() {
        return new CommandChain("cmdChnTestSketch");
    }

    public static VerbosityConfig getVerbosityConfig() {
        TreeMap flags = new TreeMap();
        VerbosityConfig verbosity = new VerbosityConfig();
        verbosity.setShowFlag(SHOW_TYPE_KEY, true);
        verbosity.setShowFlag(SHOW_LENGTH_KEY, false);
        return verbosity;
    }

    public static BasicFileUseMgr getBasicFileUseMgr() {
        BasicFilePathSvr basicSvr = new BasicFilePathSvr();
        FilePath dbFilePath = new FilePath("filePath.desc.png", PNG_PATH);
        FilePath jpegFilePath = new FilePath("filePath.desc.jpeg", JPEG_PATH);
        basicSvr.setFilePath(dbFilePath);
        basicSvr.setFilePath(jpegFilePath);
        BasicFileUseMgr fileUseMgr = new BasicFileUseMgr(basicSvr);
        fileUseMgr.addRecentFile("PNG", PNG_RECENT_A, true);
        fileUseMgr.addRecentFile("JPEG", JPG_RECENT_A, false);
        return fileUseMgr;
    }
}

