/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.core.Glyph;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class Lasso {
    private double zoomLevel_;
    private Point start_;
    private Point cursor_;

    public Lasso(Point start, double zoomLevel) {
        this.zoomLevel_ = zoomLevel;
        this.start_ = new Point(start);
        this.cursor_ = new Point(this.start_);
    }

    public Point getStart() {
        return new Point(this.start_);
    }

    public void setCursor(Point cursor) {
        this.cursor_ = cursor;
    }

    public Point getCursor() {
        return new Point(this.cursor_);
    }

    public Rectangle getBounds() {
        Rectangle rect = new Rectangle(this.start_);
        rect.add(this.cursor_);
        return rect;
    }

    public String toString() {
        return "Lasso start: " + this.start_ + ", cursor: " + this.cursor_;
    }

    public void setSelectedGlyphs(List allGlyphs, List previouslySelectedGlyphs) {
        this.setSelectedGlyphsDisp(allGlyphs, previouslySelectedGlyphs);
    }

    private void setSelectedGlyphsDisp(List allGlyphs, List previouslySelectedGlyphs) {
        ArrayList<String> prevSelNms = new ArrayList<String>();
        if (previouslySelectedGlyphs != null) {
            for (Glyph prevGlyph : previouslySelectedGlyphs) {
                prevSelNms.add(prevGlyph.getName());
            }
        }
        Rectangle lassoBounds = this.getBounds();
        Rectangle unzoomLassoRect = Zoomer.zoom(lassoBounds, 1.0 / this.zoomLevel_);
        boolean mustEnclose = this.getMustEnclose();
        for (Glyph glyph : allGlyphs) {
            if (prevSelNms.contains(glyph.getName())) continue;
            glyph.setSelected(false);
            boolean selected = this.getGlyphSelected(unzoomLassoRect, glyph.getBounds2D(), mustEnclose);
            if (!selected) continue;
            glyph.setSelected(true);
        }
    }

    private boolean getGlyphSelected(Rectangle unzoomedLassoBounds, Rectangle2D glyphBounds, boolean mustEnclose) {
        if (mustEnclose) {
            return unzoomedLassoBounds.contains(glyphBounds);
        }
        return unzoomedLassoBounds.intersects(glyphBounds);
    }

    private boolean getMustEnclose() {
        return this.cursor_.getX() > this.start_.getX();
    }
}

