/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.xml.svg.bldr.basic.SvgTextBldr;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlyphTextLine
implements Glyph,
IDrawable,
ISvgShape {
    private String name_;
    private Font font_;
    private Color textColor_;
    private String text_;
    private Point2D start_;
    private Point coordSpace = new Point(0, 0);
    private int alignment_;
    private Rectangle2D bounds_;
    private boolean selected_;

    public GlyphTextLine(String text, Point2D start, Font font, int alignment, Color textColor) {
        this.name_ = this.text_ = text;
        this.start_ = new Point2D.Double(start.getX(), start.getY());
        this.font_ = font;
        this.alignment_ = alignment;
        this.textColor_ = textColor;
        this.bounds_ = new Rectangle2D.Double(this.start_.getX(), this.start_.getY(), this.start_.getX() + (double)(5 * this.text_.length()), this.start_.getY() + 5.0);
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        Paint oldPaint = g2.getPaint();
        g2.setPaint(this.textColor_);
        g2.setFont(this.font_);
        g2.drawString(this.text_, (int)this.start_.getX(), (int)this.start_.getY());
        g2.setPaint(oldPaint);
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public List getDrawables() {
        ArrayList list = new ArrayList();
        return list;
    }

    public boolean getIsBold() {
        int style = this.getFont().getStyle();
        int masked = 1 & style;
        boolean isBold = masked == 1;
        return isBold;
    }

    public int getWidth() {
        return GuiHelper.getSwingStringLength(this.text_, this.font_);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.bounds_.contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public void setScaleFactor(double factor) {
    }

    @Override
    public void setAngle(double angle) {
    }

    public void setZoom(double zoomLevel) {
    }

    public void setDataFactory(Object factory) {
    }

    public static String getClassName() {
        return "DbTableGlyph";
    }

    @Override
    public String getName() {
        return new String(this.name_);
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public String getText() {
        return this.text_;
    }

    public Font getFont() {
        return this.font_;
    }

    public Rectangle2D getBounds() {
        return this.bounds_;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public int getAlignment() {
        return this.alignment_;
    }

    public Point2D getStart() {
        return this.start_;
    }

    public Color getTextColor() {
        return this.textColor_;
    }

    public static int getAlignLeft() {
        return 0;
    }

    public static int getAlignCenter() {
        return 1;
    }

    public static int getAlignRight() {
        return 2;
    }

    @Override
    public void move(Point p) {
        this.start_ = new Point2D.Double(p.getX(), p.getY());
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public Element getSvgElm(Document doc) {
        SvgTextBldr elmBldr = new SvgTextBldr(doc);
        elmBldr.setColor(this.getTextColor());
        boolean isBold = this.getIsBold();
        int xBoldShift = isBold ? this.getX_BoldShift() : 0;
        Point pt = new Point(this.coordSpace.x + (int)this.start_.getX() + xBoldShift, this.coordSpace.y + (int)this.start_.getY());
        Element elm = elmBldr.buildElm(this.text_, pt, isBold);
        return elm;
    }

    private int getX_BoldShift() {
        double compRate = 0.7;
        int compensation = (int)((double)this.getText().length() * 0.7);
        return compensation;
    }
}

