/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import com.harrand.util.MathUtil;
import com.harrand.util.XmlHelper;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GlyphImage
implements Glyph,
ISvgShape,
IDrawable {
    private Point2D start_;
    private boolean selected_;
    private final BufferedImage image_;
    private double scaleFactor_ = 1.0;
    private Point coordSpace = new Point();
    private String svgIconIdStr = null;
    public static final double RENDER_RATIO = 0.6;

    public GlyphImage(BufferedImage image, Point2D start) {
        this.image_ = image;
        this.start_ = new Point2D.Double(start.getX(), start.getY());
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor_ = scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor_;
    }

    public double getRenderFactor() {
        return 0.6 * this.scaleFactor_;
    }

    public BufferedImage getBufferedImage() {
        return this.image_;
    }

    public Point2D getStart() {
        return new Point2D.Double(this.start_.getX(), this.start_.getY());
    }

    public int getScaledWidth() {
        double scaledWidth = (double)this.image_.getWidth() * this.getRenderFactor();
        return MathUtil.round(scaledWidth);
    }

    public int getScaledHeight() {
        return MathUtil.round((double)this.image_.getHeight() * this.getRenderFactor());
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public void setSvgIconIdStr(String svgIconIdStr) {
        this.svgIconIdStr = svgIconIdStr;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        AffineTransform tx = new AffineTransform();
        tx.scale(this.getRenderFactor(), this.getRenderFactor());
        AffineTransformOp txOp = new AffineTransformOp(tx, 2);
        g2.drawImage(this.getBufferedImage(), txOp, (int)this.getStart().getX(), (int)this.getStart().getY());
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D.Double bounds = this.image_ != null ? new Rectangle2D.Double(this.start_.getX(), this.start_.getY(), this.image_.getWidth(), this.image_.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        return bounds;
    }

    public List getDrawables() {
        return new ArrayList();
    }

    @Override
    public void move(Point p) {
        this.start_ = new Point2D.Double(p.getX(), p.getY());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getBounds2D().contains(x, y);
    }

    @Override
    public String getName() {
        return "Image: " + this.start_.toString();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public Element getSvgElm(Document doc) {
        boolean hasSvgIconId;
        boolean bl = hasSvgIconId = this.svgIconIdStr != null;
        if (hasSvgIconId) {
            Element elm = this.getSvgElmDisp(doc);
            return elm;
        }
        return null;
    }

    private Element getSvgElmDisp(Document doc) throws DOMException {
        Element elm = XmlHelper.createElementSimple(doc, "use", "");
        elm.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + this.svgIconIdStr);
        Point pt = new Point(this.coordSpace.x + (int)this.start_.getX(), this.coordSpace.y + (int)this.start_.getY());
        XmlHelper.setAttr(elm, "x", pt.x);
        XmlHelper.setAttr(elm, "y", pt.y);
        return elm;
    }
}

