/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public final class GeometryHelper {
    public static Point2D getCenterPoint(Rectangle2D rect) {
        return new Point2D.Double(rect.getCenterX(), rect.getCenterY());
    }

    public static Point2D getOrigin(Rectangle2D rect) {
        return new Point2D.Double(rect.getX(), rect.getY());
    }

    public static int getDistance(Rectangle2D rectA, Rectangle2D rectB) {
        Point2D centerA = GeometryHelper.getCenterPoint(rectA);
        Point2D centerB = GeometryHelper.getCenterPoint(rectB);
        return (int)centerA.distance(centerB);
    }

    public static Rectangle2D getMaxBounds(Rectangle2D rectA, Rectangle2D rectB) {
        double minX = rectA.getMinX() < rectB.getMinX() ? rectA.getMinX() : rectB.getMinX();
        double minY = rectA.getMinY() < rectB.getMinY() ? rectA.getMinY() : rectB.getMinY();
        double maxX = rectA.getMaxX() > rectB.getMaxX() ? rectA.getMaxX() : rectB.getMaxX();
        double maxY = rectA.getMaxY() > rectB.getMaxY() ? rectA.getMaxY() : rectB.getMaxY();
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static boolean isRectNorth(Rectangle2D rectA, Rectangle2D rectB) {
        return rectA.getCenterY() <= rectB.getCenterY();
    }

    public static boolean isRectWest(Rectangle2D rectA, Rectangle2D rectB) {
        return rectA.getCenterX() <= rectB.getCenterX();
    }

    public static Rectangle2D getRectFromPoints(Point2D ptA, Point2D ptB) {
        Rectangle2D.Double rect = new Rectangle2D.Double(ptA.getX(), ptA.getY(), 0.0, 0.0);
        rect.add(ptB);
        return rect;
    }

    public static Rectangle2D getRect2D(Rectangle rect) {
        Rectangle2D.Double rect2D = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        return rect2D;
    }

    public static Rectangle getRect(Rectangle rect) {
        Rectangle newRect = new Rectangle(rect);
        return newRect;
    }

    public static RoundRectangle2D getRoundRect(Rectangle2D rect, double r) {
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), r, r);
        return roundRect;
    }

    public static boolean isRectSame(Rectangle2D rect, Point pt, long width, long height) {
        return GeometryHelper.isRectSame(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), pt, width, height);
    }

    public static boolean isRectSame(RoundRectangle2D rect, Point pt, long width, long height) {
        return GeometryHelper.isRectSame(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), pt, width, height);
    }

    public static boolean isRectSame(RoundRectangle2D oldRect, RoundRectangle2D newRect) {
        if (Math.round(oldRect.getX()) != Math.round(newRect.getX())) {
            return false;
        }
        if (Math.round(oldRect.getY()) != Math.round(newRect.getY())) {
            return false;
        }
        if (Math.round(oldRect.getWidth()) != Math.round(newRect.getWidth())) {
            return false;
        }
        return Math.round(oldRect.getHeight()) == Math.round(newRect.getHeight());
    }

    public static boolean isRectSame(double rectX, double rectY, double rectW, double rectH, Point pt, long width, long height) {
        if (width != Math.round(rectW)) {
            return false;
        }
        if (height != Math.round(rectH)) {
            return false;
        }
        if ((long)pt.x != Math.round(rectX)) {
            return false;
        }
        return (long)pt.y == Math.round(rectY);
    }

    public static Point2D add(Point2D pA, Point2D pB) {
        return GeometryHelper.move(pA, pB.getX(), pB.getY());
    }

    public static Point2D move(Point2D p, double deltaX, double deltaY) {
        Point2D.Double ptNew = new Point2D.Double(p.getX() + deltaX, p.getY() + deltaY);
        return ptNew;
    }

    public static Line2D move(Line2D line, double deltaX, double deltaY) {
        Line2D.Double newLine = new Line2D.Double(line.getX1() + deltaX, line.getY1() + deltaY, line.getX2() + deltaX, line.getY2() + deltaY);
        return newLine;
    }

    public static RoundRectangle2D move(RoundRectangle2D rect, Point delta) {
        RoundRectangle2D.Double newRect = new RoundRectangle2D.Double(rect.getX() + delta.getX(), rect.getY() + delta.getY(), rect.getWidth(), rect.getHeight(), rect.getArcWidth(), rect.getArcHeight());
        return newRect;
    }

    public static Rectangle2D move(Rectangle2D rect, Point delta) {
        Rectangle2D.Double newRect = new Rectangle2D.Double(rect.getX() + delta.getX(), rect.getY() + delta.getY(), rect.getWidth(), rect.getHeight());
        return newRect;
    }

    public static Rectangle2D move(Rectangle2D rect, Point2D delta) {
        Rectangle2D.Double newRect = new Rectangle2D.Double(rect.getX() + delta.getX(), rect.getY() + delta.getY(), rect.getWidth(), rect.getHeight());
        return newRect;
    }

    public static int getArcRadius(Arc2D arc) {
        Point2D start = arc.getStartPoint();
        Point2D.Double center = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
        return (int)start.distance(center);
    }

    public static Point2D rotatePointJ2D(Point2D p, double degrees) {
        degrees = GeometryHelper.normalizeAngle(degrees);
        Point2D pt = GeometryHelper.rotatePoint(new Point2D.Double(p.getX(), -p.getY()), degrees);
        return new Point2D.Double(pt.getX(), -pt.getY());
    }

    public static double getAngleJ2D(Point2D ptA, Point2D ptB) {
        double radians = Math.atan2(-ptB.getY() - -ptA.getY(), ptB.getX() - ptA.getX());
        return Math.toDegrees(radians);
    }

    public static String getLineStr(Line2D line) {
        return "x1=" + line.getX1() + ", y1=" + line.getY1() + ", x2=" + line.getX2() + ", y2=" + line.getY2();
    }

    public static Line2D extendLine(Line2D line, double extension) {
        Point2D p1 = line.getP1();
        Point2D p2 = line.getP2();
        double length = p1.distance(p2);
        double p3x = p1.getX() + (p1.getX() - p2.getX()) / length * extension;
        double p3y = p1.getY() + (p1.getY() - p2.getY()) / length * extension;
        double p4x = p2.getX() + (p2.getX() - p1.getX()) / length * extension;
        double p4y = p2.getY() + (p2.getY() - p1.getY()) / length * extension;
        Line2D.Double newLine = new Line2D.Double(p3x, p3y, p4x, p4y);
        return newLine;
    }

    public static boolean isLineHorizontal(Line2D line) {
        return Math.round(line.getY1()) == Math.round(line.getY2());
    }

    public static boolean isLineVertical(Line2D line) {
        return Math.round(line.getX1()) == Math.round(line.getX2());
    }

    public static Point2D rotatePoint(Point2D p, double degrees) throws IllegalArgumentException {
        if (degrees >= 0.0 && degrees <= 360.0) {
            double x = p.getX();
            double y = p.getY();
            double hyp = Point2D.distance(x, y, 0.0, 0.0);
            double baseAngle = Math.atan2(y, x);
            double totalRadians = baseAngle + Math.toRadians(degrees);
            double cos = Math.cos(totalRadians);
            double newX = hyp * Math.cos(totalRadians);
            double newY = hyp * Math.sin(totalRadians);
            return new Point2D.Double(newX, newY);
        }
        throw new IllegalArgumentException("Angle must be between 0 and 360, but supplied value was: " + Double.toString(degrees));
    }

    public static ArrayList rotatePoints(ArrayList points, double degrees) {
        ArrayList<Point2D> rotated = new ArrayList<Point2D>();
        for (Point2D p : points) {
            rotated.add(GeometryHelper.rotatePoint(p, degrees));
        }
        return rotated;
    }

    public static double reduceAngle(double degrees) {
        if (degrees >= 0.0) {
            int factor = (int)(degrees / 360.0);
            return degrees - (double)(factor * 360);
        }
        return -GeometryHelper.reduceAngle(-degrees);
    }

    public static double normalizeAngle(double degrees) throws IllegalArgumentException {
        if (degrees <= 360.0 && degrees >= -360.0) {
            if (degrees < 0.0) {
                return 360.0 + degrees;
            }
            return degrees;
        }
        throw new IllegalArgumentException("Angle must be between -360 and 360, but supplied value was: " + Double.toString(degrees));
    }

    public static Ellipse2D getEllipse(Point2D center, double width, double height) {
        Point2D.Double basePoint = new Point2D.Double(center.getX() - 0.5 * width, center.getY() - 0.5 * height);
        return new Ellipse2D.Double(((Point2D)basePoint).getX(), ((Point2D)basePoint).getY(), width, height);
    }
}

