/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.draw;

import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.glyph.calc.IconGlyphSizeCalc;
import com.harrand.util.LogUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ClickActionIconImgBldr {
    private Rectangle2D clickActionRect;
    private BufferedImage iconBI;
    private IconGlyphSizeCalc iconGlyphSizeCalc = new IconGlyphSizeCalc();
    private double scaleFactor;

    public GlyphImage getIconImgGlyph(BufferedImage iconBI, Rectangle2D clickActionRect, double scaleFactor) {
        this.iconBI = iconBI;
        this.clickActionRect = clickActionRect;
        this.scaleFactor = scaleFactor;
        Point2D iconOrigin = this.getIconOrigin();
        GlyphImage glyphImg = new GlyphImage(iconBI, iconOrigin);
        glyphImg.setScaleFactor(scaleFactor);
        return glyphImg;
    }

    private Point2D getIconOrigin() {
        double clickActionX = this.clickActionRect.getX();
        double clickActionY = this.clickActionRect.getY();
        Point2D.Double iconOrigin = new Point2D.Double(clickActionX + this.getHorzOffset() + 0.5, clickActionY + this.getVertOffset() + 0.5);
        return iconOrigin;
    }

    private double getHorzOffset() {
        double clickActionWidth = this.clickActionRect.getWidth();
        int iconWidth = this.iconGlyphSizeCalc.getIconWidth(this.scaleFactor);
        return this.getOffset(clickActionWidth, iconWidth, "width");
    }

    private double getVertOffset() {
        int iconHeight = this.iconGlyphSizeCalc.getIconHeight(this.scaleFactor);
        return this.getOffset(this.clickActionRect.getHeight(), iconHeight, "height");
    }

    private double getOffset(double clickActionValue, double iconValue, String dimensionStr) {
        double offset = 0.0;
        double surplus = clickActionValue - iconValue;
        if (surplus >= 0.0) {
            offset = surplus / 2.0;
        } else {
            LogUtil.logErr("ClickActionIconImgBldr.error: Icon " + dimensionStr + " bigger than click action " + dimensionStr);
        }
        return offset;
    }
}

