/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.bldr;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.bldr.IClickActionBldr;
import com.harrand.sketch.command.clickAction.draw.ClickActionPosCalc;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.sketch.command.clickAction.zone.DeleteZoneClickAction2;
import com.harrand.sketch.command.clickAction.zone.RenameZoneIconClickAction;
import com.harrand.sketch.command.clickAction.zone.RenameZoneTextClickAction;
import com.harrand.sketch.glyph.GlyphPosUtil;
import com.harrand.sketch.glyph.ZoneGlyph;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class ZoneClickActionBldr
implements IClickActionBldr {
    private ClickActionSizeCalc sizeCalc;
    private ClickActionMouseCalc mouseCalc;
    private final ZoneGlyph zoneGlyph;
    private GlyphPosUtil posUtil = new GlyphPosUtil();
    private HashMap<String, IClickAction> CA_Map = new HashMap();
    private ClickActionPosCalc clickActionPosCalc = new ClickActionPosCalc();
    private static final int ZONE_PROPS_LEFT_POS = 1;
    private DeleteZoneClickAction2 deleteAction;
    private RenameZoneTextClickAction renameTextClickAction;
    private RenameZoneIconClickAction renameClickAction;

    public ZoneClickActionBldr(ZoneGlyph zoneGlyph) {
        this.zoneGlyph = zoneGlyph;
    }

    @Override
    public final void setSizeCalc(ClickActionSizeCalc sizeCalc) {
        this.sizeCalc = sizeCalc;
    }

    @Override
    public final void setMouseCalc(ClickActionMouseCalc mouseCalc) {
        this.mouseCalc = mouseCalc;
    }

    @Override
    public Map<String, IClickAction> getClickActionsMap() {
        this.CA_Map.clear();
        this.addRenameZoneIconClickAction();
        this.addRenameZoneTextClickAction();
        this.addDeleteZoneClickAction();
        return this.CA_Map;
    }

    @Override
    public void clear() {
        this.renameClickAction = null;
        this.renameTextClickAction = null;
        this.deleteAction = null;
    }

    private IClickAction getDeleteZoneClickAction() {
        return null;
    }

    private void addRenameZoneIconClickAction() {
        if (this.renameClickAction == null) {
            this.renameClickAction = new RenameZoneIconClickAction(this.zoneGlyph, this.sizeCalc, this.mouseCalc);
        }
        this.renameClickAction.setMouseCalc(this.mouseCalc);
        Point2D topLeft = this.posUtil.getTableLeftPositionTopLeft(1);
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromGlyphImg(topLeft);
        this.renameClickAction.setOrigin(origin);
        this.putClickAction(this.renameClickAction);
    }

    private void addRenameZoneTextClickAction() {
        if (this.renameTextClickAction == null) {
            this.renameTextClickAction = new RenameZoneTextClickAction(this.zoneGlyph, this.sizeCalc, this.mouseCalc);
        }
        this.renameTextClickAction.setMouseCalc(this.mouseCalc);
        Point textOrigin = this.getTextOrigin();
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromCursor(textOrigin, this.getLineHeight());
        this.renameTextClickAction.setOrigin(origin);
        this.putClickAction(this.renameTextClickAction);
    }

    private void addDeleteZoneClickAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteZoneClickAction2(this.zoneGlyph, this.sizeCalc, this.mouseCalc);
        }
        this.deleteAction.setMouseCalc(this.mouseCalc);
        Point textOrigin = this.getTextOrigin();
        Font zoneTitleFont = this.zoneGlyph.getTitleFont();
        double textWidth = GuiHelper.getSwingStringLength(this.zoneGlyph.getDisplayNm(), zoneTitleFont);
        double cursorX = textOrigin.getX() + textWidth;
        Point2D.Double cursor = new Point2D.Double(cursorX, textOrigin.getY());
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromCursor(cursor, this.getLineHeight());
        this.deleteAction.setOrigin(origin);
        this.putClickAction(this.deleteAction);
    }

    private Point getTextOrigin() {
        return this.zoneGlyph.getHeaderGlyph().getTextOrigin();
    }

    private void putClickAction(IClickAction clickAction) {
        this.CA_Map.put(clickAction.getName(), clickAction);
    }

    private double getLineHeight() {
        return this.zoneGlyph.getRenderConfig().getLineHeight();
    }
}

