/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.action;

import com.harrand.coregui.command.Command;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.draw.ClickActionIconImgBldr;
import com.harrand.sketch.command.clickAction.draw.HoverOverBtnDrawer;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BaseClickAction
implements IClickAction {
    protected final ClickActionSizeCalc sizeCalc;
    protected ClickActionMouseCalc mouseCalc;
    private ClickActionIconImgBldr iconImgBldr = new ClickActionIconImgBldr();
    private HoverOverBtnDrawer hoverBtnDrawer = new HoverOverBtnDrawer();
    private Collection<IDrawable> hoverBtnDrawables = new ArrayList<IDrawable>();
    private Collection<IDrawable> drawables = new ArrayList<IDrawable>();
    protected Command cmd;
    private BufferedImage drawImg;
    private BufferedImage iconImg;
    private String name;
    private String text = null;
    private boolean isBold;
    private boolean isEnlargedFont;
    protected Point2D origin;
    private Rectangle2D drawRect;
    private Rectangle2D mouseRect;

    public BaseClickAction(ClickActionSizeCalc sizeCalc, ClickActionMouseCalc mouseCalc) {
        this.sizeCalc = sizeCalc;
        this.setMouseCalc(mouseCalc);
        this.clearDrawables();
    }

    public void setMouseCalc(ClickActionMouseCalc mouseCalc) {
        this.mouseCalc = mouseCalc;
    }

    @Override
    public void setOrigin(Point2D origin) {
        Point2D shiftedOrigin = origin;
        if (this.isTextClickAction()) {
            double shiftX = origin.getX() - 3.0 - 1.0;
            shiftedOrigin = new Point2D.Double(shiftX, origin.getY());
        }
        this.origin = shiftedOrigin;
        this.calcRects();
    }

    @Override
    public Collection<IDrawable> getDrawables() {
        this.drawables.clear();
        boolean displayable = this.isDisplayable();
        if (displayable) {
            this.drawables.addAll(this.hoverBtnDrawables);
            this.checkAddIconGlyph(this.drawables);
        }
        return this.drawables;
    }

    @Override
    public Point2D getOrigin() {
        return this.origin;
    }

    public void setCommand(Command cmd) {
        this.cmd = cmd;
    }

    protected void setIsBold(boolean isBold) {
        this.isBold = isBold;
    }

    public void setIsEnlargedFont(boolean isEnlargedFont) {
        this.isEnlargedFont = isEnlargedFont;
    }

    protected final void calcRects() {
        this.calcDrawRect();
        this.mouseRect = this.mouseCalc.getMouseRect(this.drawRect);
    }

    private void calcDrawRect() {
        double x = this.origin.getX();
        double y = this.origin.getY();
        this.drawRect = this.isTextClickAction() ? this.sizeCalc.getTextDrawRect(this.text, this.isBold, this.isEnlargedFont, x, y) : this.sizeCalc.getButtonDrawRect(x, y);
    }

    @Override
    public void mouseMoved(Point pt) {
        boolean isDirectlyOver = this.contains(pt);
        if (isDirectlyOver) {
            this.drawImg = this.iconImg;
            this.setHoverDrawables();
        } else {
            this.drawImg = null;
            this.clearDrawables();
        }
    }

    @Override
    public boolean mouseClicked(Point pt) {
        boolean isOver = this.contains(pt);
        if (isOver) {
            if (this.cmd != null) {
                this.cmd.actionPerformed(null);
            } else {
                this.doAction();
            }
        }
        return isOver;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setIconImg(BufferedImage img) {
        this.iconImg = img;
    }

    private boolean contains(Point pt) {
        boolean contains = this.mouseRect.contains(pt);
        return contains;
    }

    private double getWidth() {
        return this.drawRect.getWidth();
    }

    private boolean isDrawRectReady() {
        boolean ready = this.drawRect != null;
        return ready;
    }

    private double getHeight() {
        return this.drawRect.getHeight();
    }

    private void checkAddIconGlyph(Collection<IDrawable> drawables) {
        if (!this.isTextClickAction()) {
            GlyphImage iconImgGlyph = this.iconImgBldr.getIconImgGlyph(this.drawImg, this.drawRect, this.sizeCalc.getScaleFactor());
            drawables.add(iconImgGlyph);
        }
    }

    private void clearDrawables() {
        this.hoverBtnDrawables = new ArrayList<IDrawable>();
    }

    private boolean isTextClickAction() {
        return this.text != null;
    }

    private void setHoverDrawables() {
        this.hoverBtnDrawables = this.hoverBtnDrawer.getDrawables(this.origin, this.getWidth(), this.getHeight());
    }

    private boolean isDisplayable() {
        if (this.isTextClickAction()) {
            return this.isDrawRectReady();
        }
        return this.isDrawRectReady() && this.isDrawImgReady();
    }

    private boolean isDrawImgReady() {
        return this.drawImg != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

