/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.util.ArrayList;
import java.util.List;

public final class RemoveGlyphs
extends Command {
    private String name_ = "Remove Glyphs";
    private Diagram diagram_;
    private List glyphs_;

    public RemoveGlyphs(Diagram diagram, List glyphs, int state) {
        this.setState(state);
        this.diagram_ = diagram;
        this.glyphs_ = glyphs;
        this.setProps();
    }

    @Override
    protected void setProps() {
        this.putValue("Name", this.getDoPrefix() + this.name_);
        this.putValue("ShortDescription", this.getDoPrefix() + "Remove Glyphs");
        this.putValue("LongDescription", this.getDoPrefix() + "Remove Glyphs from Diagram");
        this.putValue("MnemonicKey", new Integer(82));
        this.putValue("SmallIcon", Icons.MINUS);
    }

    @Override
    protected void execute() {
        ArrayList<String> glyphNms = new ArrayList<String>();
        for (Glyph glyph : this.glyphs_) {
            glyphNms.add(glyph.getName());
        }
        this.diagram_.removeGlyphs(glyphNms);
    }

    @Override
    public void undo() {
        this.diagram_.initAddGlyphs(this.glyphs_);
    }

    @Override
    public Command duplicate() {
        RemoveGlyphs cmdNew = new RemoveGlyphs(this.diagram_, this.glyphs_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

