/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;

public final class RemoveGlyphFromDiagram
extends Command {
    private String name_ = "Remove Glyph";
    private Diagram diagram_;
    private Glyph glyph_;

    public RemoveGlyphFromDiagram() {
        this.setEnabled(false);
        this.setProps();
    }

    public RemoveGlyphFromDiagram(Diagram diagram, Glyph glyph, int state) {
        this.setState(state);
        this.diagram_ = diagram;
        this.glyph_ = glyph;
        if (this.glyph_ != null) {
            this.name_ = this.name_ + ": " + this.glyph_.getName();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.setProps();
    }

    @Override
    protected void setProps() {
        this.putValue("Name", this.getDoPrefix() + this.name_);
        this.putValue("ShortDescription", this.getDoPrefix() + "Remove Glyph");
        this.putValue("LongDescription", this.getDoPrefix() + "Remove Glyph from Diagram");
        this.putValue("MnemonicKey", new Integer(82));
        this.putValue("SmallIcon", Icons.MINUS);
    }

    @Override
    protected void execute() {
        this.diagram_.removeGlyph(this.glyph_.getName());
    }

    @Override
    public void undo() {
        this.diagram_.addGlyph(this.glyph_);
    }

    @Override
    public Command duplicate() {
        RemoveGlyphFromDiagram cmdNew = new RemoveGlyphFromDiagram(this.diagram_, this.glyph_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

