/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.sketch.command.ExportDiagram;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.DiagramExporter;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.util.ResMgr;
import java.io.File;
import javax.swing.JFileChooser;

public final class PromptExportDiagram
extends Command {
    private Diagram diagram_;
    private IFileUseMgr fileUseMgr_;
    private String formatName_;
    private File file_;
    private String name_;
    private final IDrawableOrderer drawableOrderer;

    public PromptExportDiagram(Diagram diagram, IDrawableOrderer drawableOrderer, String formatName, IFileUseMgr fileUseMgr, String displayText) {
        this.diagram_ = diagram;
        this.formatName_ = formatName;
        this.fileUseMgr_ = fileUseMgr;
        this.name_ = displayText;
        this.drawableOrderer = drawableOrderer;
        this.setProps();
    }

    @Override
    public Command duplicate() {
        PromptExportDiagram cmdNew = new PromptExportDiagram(this.diagram_, this.drawableOrderer, this.formatName_, this.fileUseMgr_, this.name_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        File defaultFile = this.getDefaultFile();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(ResMgr.getRes("image.export.label"));
        chooser.setSelectedFile(defaultFile);
        int state = chooser.showSaveDialog(GuiMessageHelper.getDefaultParent());
        File file = chooser.getSelectedFile();
        if (file != null && state == 0) {
            ExportDiagram exportCmd = new ExportDiagram(this.diagram_, this.drawableOrderer, this.formatName_, file, this.fileUseMgr_);
            exportCmd.actionPerformed(null);
        }
    }

    public File getDefaultFile() {
        File svgFile;
        if (this.formatName_.equalsIgnoreCase("SVG") && (svgFile = this.diagram_.getDiagramProps().getSvgFile()) != null) {
            return svgFile;
        }
        String fileUseName = DiagramExporter.mapToFileUseName(this.formatName_);
        File defaultFile = this.fileUseMgr_ != null ? this.fileUseMgr_.getDefaultFile(fileUseName, this.diagram_) : new File(this.diagram_.getName());
        return defaultFile;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.DIAGRAM);
    }

    @Override
    protected void undo() {
    }
}

