/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.util.ArrayList;
import java.util.List;

public class AddGlyphs
extends Command {
    private String name_ = "Add Glyphs";
    private Diagram diagram_;
    private List glyphs_;

    public AddGlyphs(Diagram diagram, List glyphs, int state) {
        this.setState(state);
        this.diagram_ = diagram;
        this.glyphs_ = glyphs;
        this.setProps();
    }

    public int getGlyphCount() {
        return this.glyphs_.size();
    }

    @Override
    protected void setProps() {
        this.putValue("Name", this.getDoPrefix() + this.name_);
        this.putValue("ShortDescription", this.getDoPrefix() + this.name_);
        this.putValue("LongDescription", this.getDoPrefix() + "Add Glyphs to Diagram");
        this.putValue("MnemonicKey", new Integer(65));
        this.putValue("SmallIcon", Icons.ADD);
    }

    @Override
    protected void execute() {
        ITestResult rslt = this.diagram_.initAddGlyphs(this.glyphs_);
        if (!rslt.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, rslt);
        }
    }

    @Override
    public void undo() {
        ArrayList<String> glyphNms = new ArrayList<String>();
        for (Glyph glyph : this.glyphs_) {
            glyphNms.add(glyph.getName());
        }
        this.diagram_.removeGlyphs(glyphNms);
    }

    @Override
    public Command duplicate() {
        AddGlyphs cmdNew = new AddGlyphs(this.diagram_, this.glyphs_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

