/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node.query;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchnb.action.query.ShowQueryWindowsCmd;
import com.harrand.dbwrenchnb.editor.EditorTC;
import com.harrand.dbwrenchnb.nb.tc.RemoveIdfCloseTC;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public final class DbQueryNbNode
extends AbstractNode {
    private DbQuery query;
    private Database db;
    public static final String TC_NM = EditorTC.class.getName();

    public DbQueryNbNode(Database db, DbQuery query) {
        super(Children.LEAF, Lookups.singleton((Object)new CollectorIdf(db, query)));
        this.query = query;
        this.db = db;
        this.setDisplayName(query.getName());
        this.setIconBaseWithExtension("com/harrand/coregui/images/query16.png");
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getEditCmd(), this.getRemoveCmd()};
    }

    public Action getPreferredAction() {
        return this.getEditCmd();
    }

    private Action getEditCmd() {
        return new ShowQueryWindowsCmd(this.query);
    }

    private Command getRemoveCmd() {
        PromptCollectionRemove promptRemoveCmd = new PromptCollectionRemove(this.db, DbQuery.getClassName(), this.query.getName());
        RemoveIdfCloseTC removeCloseCmd = new RemoveIdfCloseTC(promptRemoveCmd, TC_NM, this.query.getName());
        return removeCloseCmd;
    }
}

