/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.panel.NoteEditPanel;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class NoteNbNode
extends AbstractNode
implements IObserver {
    private Diagram diagram_;
    private Note note_;

    public NoteNbNode(Diagram diagram, Note note) {
        super(Children.LEAF, Lookups.singleton((Object)new CollectorIdf(diagram, note)));
        this.diagram_ = diagram;
        this.note_ = note;
        this.setDisplayText();
        this.setIconBaseWithExtension("com/harrand/coregui/images/pin_gb16.png");
        note.addObserver(this);
    }

    private void setDisplayText() {
        String descr = this.note_.getShortText();
        this.setDisplayName(descr);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getEditCmd(), this.getRemoveCmd()};
    }

    public Action getPreferredAction() {
        return this.getEditCmd();
    }

    private Command getEditCmd() {
        NoteEditPanel dataEditor = new NoteEditPanel(this.note_, this.diagram_);
        return new PromptCollectionUpdate(this.diagram_, this.note_, dataEditor);
    }

    private Command getRemoveCmd() {
        NoteNbNode noteNbNode = this;
        return new PromptCollectionRemove(this.diagram_, noteNbNode.note_.getClassName(), this.note_.getName());
    }

    @Override
    public void update(UpdateChain chain) {
        this.setDisplayText();
    }
}

