/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.command.props.UpdateDiagramSettings;
import com.harrand.dbwrenchnb.action.diagram.ShowDiagram;
import com.harrand.dbwrenchnb.tree.children.DiagramChildren;
import com.harrand.sketch.core.Diagram;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class DiagramNbNode
extends AbstractNode
implements IObserver {
    private Diagram diagram_;

    public DiagramNbNode(Database db, Diagram diagram) {
        super((Children)new DiagramChildren(diagram), Lookups.singleton((Object)new CollectorIdf(db, diagram)));
        this.diagram_ = diagram;
        this.updateDisplayName();
        this.setIconBaseWithExtension("com/harrand/coregui/images/relation16.gif");
        this.diagram_.addObserver(this);
    }

    private void updateDisplayName() {
        this.setDisplayName(this.diagram_.getName());
    }

    public Action getPreferredAction() {
        return new ShowDiagram(this.diagram_);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new ShowDiagram(this.diagram_), this.getRemoveCmd(), this.getShowPropertiesCmd()};
    }

    private Command getRemoveCmd() {
        Database db = LookupUtil.getLookupDb();
        return new PromptCollectionRemove(db, Diagram.getClassName(), this.diagram_.getName());
    }

    private Command getShowPropertiesCmd() {
        UpdateDiagramSettings diaCmd = new UpdateDiagramSettings(this.diagram_);
        return diaCmd;
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

