/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.ZonesChildren;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Zone;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class ZoneFolderNode
extends AbstractNode
implements IObserver {
    private Diagram diagram_;
    private String displayNm_;
    public static final String CLZ_NM = Zone.getClassName();

    public ZoneFolderNode(Diagram diagram) {
        super((Children)new ZonesChildren(diagram), Lookups.singleton((Object)new CollectorMapNm(diagram, Zone.getClassName())));
        this.diagram_ = diagram;
        this.displayNm_ = this.diagram_.getDisplayPlural(CLZ_NM);
        this.diagram_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.diagram_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddZoneCmd(this.diagram_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

