/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.TablesChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class TableFolderNode
extends AbstractNode
implements IObserver {
    private Schema schema_;
    private String displayNm_;
    public static final String CLZ_NM = Table.getClassName();

    public TableFolderNode(Schema schema) {
        super((Children)new TablesChildren(schema), Lookups.singleton((Object)new CollectorMapNm(schema, Table.getClassName())));
        this.schema_ = schema;
        this.displayNm_ = this.schema_.getDisplayPlural(CLZ_NM);
        this.schema_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.schema_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddTableCmd(this.schema_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

