/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.SchemasChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class SchemaFolderNode
extends AbstractNode
implements IObserver {
    private Database db_;
    private String displayNm_;
    public static final String CLZ_NM = Schema.getClassName();

    public SchemaFolderNode(Database db, String displayNm) {
        super((Children)new SchemasChildren(db), Lookups.singleton((Object)new CollectorMapNm(db, Schema.getClassName())));
        this.db_ = db;
        this.displayNm_ = this.db_.getDisplayPlural(CLZ_NM);
        this.db_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.db_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddSchemaCmd();
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

