/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.ProcsChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class ProcFolderNode
extends AbstractNode
implements IObserver {
    private Schema schema_;
    private String displayNm_;
    public static final String CLZ_NM = Proc.getClassName();

    public ProcFolderNode(Schema schema) {
        super((Children)new ProcsChildren(schema), Lookups.singleton((Object)new CollectorMapNm(schema, Proc.getClassName())));
        this.schema_ = schema;
        this.displayNm_ = this.schema_.getDisplayPlural(CLZ_NM);
        this.schema_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.schema_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Action getAddCmd() {
        return DbwCmdFactory.getInstance().getAddProcCmd(this.schema_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

