/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.ForeignKeysChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class ForeignKeyFolderNode
extends AbstractNode
implements IObserver {
    private Table table_;
    private static final String CLZ_NM = ForeignKey.getClassName();
    private Database db_;
    private String displayNm_;

    public ForeignKeyFolderNode(Table table) {
        super((Children)new ForeignKeysChildren(table), Lookups.singleton((Object)new CollectorMapNm(table, ForeignKey.getClassName())));
        this.table_ = table;
        this.db_ = (Database)CentralLookup.getDefault().lookup(Database.class);
        if (this.db_ == null) {
            this.db_ = new Database("emptyDb");
        }
        this.displayNm_ = this.table_.getDisplayPlural(CLZ_NM);
        this.table_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.table_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddFkCmd(this.table_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

