/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.ColumnsChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class ColumnFolderNode
extends AbstractNode
implements IObserver {
    private Table table_;
    private String displayNm_;
    private static final String CLZ_NM = Column.getClassName();

    public ColumnFolderNode(Table table) {
        super((Children)new ColumnsChildren(table), Lookups.singleton((Object)new CollectorMapNm(table, Column.getClassName())));
        this.table_ = table;
        this.displayNm_ = this.table_.getDisplayPlural(CLZ_NM);
        this.table_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.table_.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddColumnCmd(this.table_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

