/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.toolbar;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

@Deprecated
public final class ZoomToolbarNb
extends CallableSystemAction
implements IObserver,
MouseListener {
    private static ZoomToolbarNb instance__ = null;
    private Diagram diagram_ = null;
    private JLabel lblLevel_ = new JLabel("    %");
    private JLabel lblClickActionsOn = new JLabel("", ICON_ON, 0);
    private static final ImageIcon ICON_ON = Icons.CLICK_ACTIONS_ON;
    private static final ImageIcon ICON_OFF = Icons.CLICK_ACTIONS_OFF;
    private static final String BLANK_TEXT = "    %";

    public ZoomToolbarNb() {
        CentralLookup.getDefault().addObserver(this);
        instance__ = this;
        this.setCosmetics();
        this.addListeners();
    }

    public static ZoomToolbarNb getInstance() {
        return instance__;
    }

    public Component getToolbarPresenter() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.lblLevel_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.lblClickActionsOn);
        panel.add(Box.createHorizontalStrut(5));
        return panel;
    }

    public void setDiagram(Diagram diagram) {
        this.checkRemoveObserver();
        this.diagram_ = diagram;
        if (this.isDiagramSet()) {
            this.diagram_.addObserver(this);
            this.addRcObserver();
        }
        this.refresh();
    }

    private void addRcObserver() {
        this.getRc().addObserver(this);
    }

    private void checkRemoveObserver() {
        if (this.isDiagramSet()) {
            this.diagram_.removeObserver(this);
        }
    }

    private RenderConfig getRc() {
        return this.diagram_.getRenderConfig();
    }

    private void refreshClickActionBtn() {
        this.lblClickActionsOn.setEnabled(true);
        ImageIcon displayIcon = this.getClickActionOn() ? ICON_ON : ICON_OFF;
        this.lblClickActionsOn.setIcon(displayIcon);
    }

    private boolean getClickActionOn() {
        return this.getRc().getClickActionsOn();
    }

    private void setBlankText() {
        this.lblLevel_.setText(BLANK_TEXT);
    }

    private void refresh() {
        if (this.isDiagramSet()) {
            Double asPercent = this.diagram_.getZoom().getLevelObject() * 100.0;
            int zmInt = (int)asPercent.doubleValue();
            String txt = zmInt + " %";
            this.lblLevel_.setText(txt);
            this.refreshClickActionBtn();
        } else {
            this.setBlankText();
            this.lblClickActionsOn.setEnabled(false);
        }
    }

    private void toggleClickActions() {
        boolean lastSetting = this.getClickActionOn();
        this.getRc().setClickActionsOn(!lastSetting);
    }

    private boolean isDiagramSet() {
        return this.diagram_ != null;
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    public String getName() {
        return "Zoom Toolbar";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
    }

    private void setCosmetics() {
        this.lblClickActionsOn.setToolTipText("Toggle Click Actions (Ctrl+F3)");
        Dimension size = new Dimension(24, 24);
        this.lblClickActionsOn.setMinimumSize(size);
        this.lblClickActionsOn.setPreferredSize(size);
    }

    private void addListeners() {
        this.lblClickActionsOn.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.toggleClickActions();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lblClickActionsOn.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lblClickActionsOn.setBorder(null);
    }
}

