/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.forward.tree;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.script.ScriptMgr;
import com.harrand.dbwrench.script.builder.DatabaseScriptBuilder;
import com.harrand.dbwrenchnb.nb.NodeExpansionMgr;
import com.harrand.dbwrenchnb.server.forward.tree.ScriptNbNode;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ScriptHierarchyTopComponent
extends TopComponent
implements ExplorerManager.Provider,
IObserver,
LookupListener {
    private static ScriptHierarchyTopComponent instance;
    private ExplorerManager mgr_ = new ExplorerManager();
    private ScriptMgr scriptMgr_ = ScriptMgr.getInstance();
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private Database db_ = null;
    private IScript fullScript_ = null;
    private NodeExpansionMgr expansionMgr_;
    private Lookup.Result lookupResultStep_ = null;
    private Lookup.Result lookupResultScript_ = null;
    public static final String PREFERRED_ID = "ScriptHierarchyTopComponent";
    private JScrollPane jScrollPane1;

    private ScriptHierarchyTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ScriptHierarchyTopComponent.class, (String)"CTL_ScriptHierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScriptHierarchyTopComponent.class, (String)"HINT_ScriptHierarchyTopComponent"));
        this.expansionMgr_ = new NodeExpansionMgr((TreeView)this.jScrollPane1);
        this.setFullScript(DatabaseScriptBuilder.getEmptyScript());
        this.scriptMgr_.addObserver(this);
        this.centralLookup_.addObserver(this);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.mgr_, (ActionMap)this.getActionMap()));
        this.addLookupListeners();
    }

    public void setFullScript(IScript script) {
        this.fullScript_ = script;
        this.storeExpanded();
        this.storeSelectedNode();
        this.mgr_.setRootContext((Node)new ScriptNbNode(this.fullScript_));
        this.reExpand();
        if (!this.isEmptyScript(script)) {
            this.requestActive();
        }
        this.selectLastNode();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr_;
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(ScriptMgr.class.getName())) {
            this.checkFullScript();
        }
        if (LookupUtil.isDbLookupUpdate(chain)) {
            this.checkDbChanged();
            this.db_ = LookupUtil.getLookupDb();
        }
    }

    private void addLookupListeners() {
        this.addScriptLookupListener();
        this.addStepLookupListener();
    }

    private void addStepLookupListener() {
        Lookup.Template tplStep = new Lookup.Template(BasicStep.class);
        this.lookupResultStep_ = Utilities.actionsGlobalContext().lookup(tplStep);
        this.lookupResultStep_.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance(ev);
                if (obj instanceof IStep) {
                    IStep step = (IStep)obj;
                    ScriptHierarchyTopComponent.this.scriptMgr_.setSelectedStep(step);
                }
            }
        });
    }

    private void addScriptLookupListener() {
        Lookup.Template tplScript = new Lookup.Template(BasicScript.class);
        this.lookupResultScript_ = Utilities.actionsGlobalContext().lookup(tplScript);
        this.lookupResultScript_.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance(ev);
                if (obj instanceof IScript) {
                    IScript script = (IScript)obj;
                    ScriptHierarchyTopComponent.this.scriptMgr_.setSelectedStep(script);
                }
            }
        });
    }

    public void resultChanged(LookupEvent ev) {
        Object obj = LookupUtil.getFirstInstance(ev);
        if (obj instanceof IStep) {
            IStep step = (IStep)obj;
            this.scriptMgr_.setSelectedStep(step);
        }
    }

    private void checkDbChanged() {
        if (LookupUtil.hasDbChanged(this.db_)) {
            this.clear();
        }
    }

    private void checkFullScript() {
        IScript mgrScript = this.scriptMgr_.getFullScript();
        if (!this.fullScript_.equals(mgrScript)) {
            this.setFullScript(mgrScript);
        }
    }

    private void clear() {
        this.setFullScript(DatabaseScriptBuilder.getEmptyScript());
    }

    private boolean isEmptyScript(IScript script) {
        String scpNm = script.getName();
        String emptyNm = ResMgr.getRes("script.empty.label");
        return emptyNm.equals(scpNm);
    }

    private void reExpand() {
        Node root = this.mgr_.getRootContext();
        if (root != null && this.expansionMgr_ != null) {
            this.expansionMgr_.expandNodes(root);
        }
    }

    private void storeExpanded() {
        Node root = this.mgr_.getRootContext();
        if (root != null && this.expansionMgr_ != null && !this.isComparing()) {
            this.expansionMgr_.storeExpanded(root);
        }
    }

    private void storeSelectedNode() {
        if (!this.isComparing()) {
            Node[] selectedNodes = this.mgr_.getSelectedNodes();
            Node selectedNode = null;
            if (selectedNodes.length > 0) {
                selectedNode = selectedNodes[0];
            }
            this.expansionMgr_.storeLastSelectedPath(selectedNode);
        }
    }

    private void selectLastNode() {
        this.expansionMgr_.selectLastSelectedNode(this.mgr_);
    }

    private boolean isComparing() {
        Node root = this.mgr_.getRootContext();
        String comparingStr = "Comparing Databases...";
        boolean isComparing = root.getDisplayName().equals(comparingStr);
        return isComparing;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public static synchronized ScriptHierarchyTopComponent getDefault() {
        if (instance == null) {
            instance = new ScriptHierarchyTopComponent();
        }
        return instance;
    }

    public static synchronized ScriptHierarchyTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ScriptHierarchyTopComponent.class.getName()).warning("Cannot find ScriptHierarchyTopComponent component. It will not be located properly in the window system.");
            return ScriptHierarchyTopComponent.getDefault();
        }
        if (win instanceof ScriptHierarchyTopComponent) {
            return (ScriptHierarchyTopComponent)win;
        }
        Logger.getLogger(ScriptHierarchyTopComponent.class.getName()).warning("There seem to be multiple components with the 'ScriptHierarchyTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ScriptHierarchyTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentActivated() {
        super.componentActivated();
    }

    protected void componentShowing() {
        super.componentShowing();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ScriptHierarchyTopComponent.getDefault();
        }
    }
}

