/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.forward;

import com.harrand.coreclasses.notification.ISubscriber;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrenchnb.nb.NbUtil;
import java.io.IOException;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ForEngLogger
implements ISubscriber {
    private static ForEngLogger instance__ = new ForEngLogger();
    private JdbcScriptCtrl scriptCtrl_;
    private InputOutput io_ = IOProvider.getDefault().getIO("Forward Engineer Log", false);
    public static final String FOR_ENG_LOG_NM = "Forward Engineer Log";

    private ForEngLogger() {
    }

    public static ForEngLogger getInstance() {
        return instance__;
    }

    public void setScriptCtrl(JdbcScriptCtrl scriptCtrl) {
        this.scriptCtrl_ = scriptCtrl;
        this.scriptCtrl_.setLogSubscriber(this);
    }

    public void clear() {
        try {
            this.io_.getOut().reset();
        }
        catch (IOException ex) {
            NbUtil.logMsg("ForEngLogger.error: " + ex.getMessage());
        }
    }

    private void makeLogEntry() {
        String plainMsg = this.scriptCtrl_.getPlainMsg();
        String errorMsg = this.scriptCtrl_.getErrorMsg();
        if (plainMsg != null) {
            this.log(this.io_.getOut(), plainMsg);
        }
        if (errorMsg != null) {
            OutputWriter errOut = this.io_.getErr();
            this.log(errOut, "===========================================================");
            this.log(errOut, errorMsg);
            this.log(errOut, "===========================================================");
        }
    }

    private void log(OutputWriter out, String msg) {
        out.println(msg);
        out.close();
        this.io_.select();
    }

    @Override
    public void notifyInfoReady() {
        this.makeLogEntry();
    }
}

