/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.conn;

import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrenchgui.security.AuthenticationMgr;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public class ConnChecker {
    public static boolean isConfigValid(JdbcConfig currentCfg) {
        boolean isValidSoFar = ConnChecker.isConfigSet(currentCfg);
        if (isValidSoFar && (isValidSoFar = ConnChecker.isAuthenticatedPrompt())) {
            currentCfg = ConnMgr.getInstance().getCurrentCfg();
            isValidSoFar = ConnChecker.isConnectable(currentCfg);
        }
        return isValidSoFar;
    }

    private static boolean isConnectable(JdbcConfig currentCfg) {
        try {
            Connection conn = ConnectionFactory.getConnection(currentCfg);
            ConnectionFactory.close(conn);
            return true;
        }
        catch (SQLException ex) {
            String cleanMsg = JdbcHelper.cleanMySqlConnErrMsg(ex.getMessage());
            GuiMessageHelper.showGeneralAppErrMsg(null, cleanMsg);
            return false;
        }
    }

    public static boolean isConfigSet(JdbcConfig currentCfg) {
        boolean isSet = true;
        if (currentCfg == null) {
            isSet = false;
            Frame frame = WindowManager.getDefault().getMainWindow();
            JOptionPane.showMessageDialog(frame, "No Connection is selected.", "Database Connection", 2);
        }
        return isSet;
    }

    private static boolean isAuthenticatedPrompt() {
        AuthenticationMgr mgr = AuthenticationMgr.getInstance();
        return mgr.isAuthenticatedPrompt();
    }
}

