/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server;

import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.jdesktop.swingworker.IProcessObserver;
import com.harrand.coregui.table.ResultsGridPanel;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchnb.panel.EmptyPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@Deprecated
public final class SqlResultsTopComponent
extends TopComponent
implements IProcessObserver {
    private List<ResultsGridPanel> gridPanels = new ArrayList<ResultsGridPanel>();
    private JTabbedPane tabPane_ = new JTabbedPane(1);
    private JPanel singleResultPanel_ = new JPanel(new BorderLayout());
    private EmptyPanel emptyPanel_ = new EmptyPanel("No Query Run");
    private int cmdCount_ = 0;
    private boolean tabPaneAdded_ = false;
    private static final int TAB_MAX_CHARS = 30;
    private static SqlResultsTopComponent instance;
    private static final String PREFERRED_ID = "SqlResultsTopComponent";

    private SqlResultsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SqlResultsTopComponent.class, (String)"CTL_SqlResultsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SqlResultsTopComponent.class, (String)"HINT_SqlResultsTopComponent"));
        this.setLayout(new BorderLayout());
        this.add(this.emptyPanel_, "Center");
    }

    public void clear() {
        this.gridPanels = new ArrayList<ResultsGridPanel>();
        GuiHelper.clearTabs(this.tabPane_);
        this.singleResultPanel_.removeAll();
    }

    public void setCmdCount(int cmdCount) {
        this.cmdCount_ = cmdCount;
        this.setContainerPanel();
    }

    private boolean useTabPanel() {
        return this.cmdCount_ > 1;
    }

    private void setContainerPanel() {
        this.removeAll();
        if (this.useTabPanel()) {
            this.add(this.tabPane_, "Center");
        } else {
            this.add(this.singleResultPanel_, "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void addToContainer(int resultIdx, String tabStr, ResultsGridPanel resultsGridPanel) {
        if (this.useTabPanel()) {
            this.tabPane_.addTab(tabStr, resultsGridPanel);
        } else {
            this.singleResultPanel_.add((Component)resultsGridPanel, "Center");
        }
        resultsGridPanel.refresh();
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized SqlResultsTopComponent getDefault() {
        if (instance == null) {
            instance = new SqlResultsTopComponent();
        }
        return instance;
    }

    public static synchronized SqlResultsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(SqlResultsTopComponent.class.getName()).warning("Cannot find SqlResultsTopComponent component. It will not be located properly in the window system.");
            return SqlResultsTopComponent.getDefault();
        }
        if (win instanceof SqlResultsTopComponent) {
            return (SqlResultsTopComponent)win;
        }
        Logger.getLogger(SqlResultsTopComponent.class.getName()).warning("There seem to be multiple components with the 'SqlResultsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return SqlResultsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public void process(List dataResults) {
        DbUser dbUser = App.getUser();
        this.setCmdCount(dataResults.size());
        for (int i = 0; i < dataResults.size(); ++i) {
            DbDataResult result = (DbDataResult)dataResults.get(i);
            int resultIdx = result.getCmdIndex();
            String tabStr = StrHelper.getTruncated(result.getCmdText(), 30);
            if (resultIdx < this.gridPanels.size()) continue;
            ResultsGridPanel resultsGridPanel = new ResultsGridPanel(dbUser, result);
            this.gridPanels.add(resultsGridPanel);
            this.addToContainer(resultIdx, tabStr, resultsGridPanel);
            if (!this.useTabPanel()) continue;
            this.tabPane_.setIconAt(resultIdx, resultsGridPanel.getIcon());
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return SqlResultsTopComponent.getDefault();
        }
    }
}

