/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.panel.detail;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.AddRemoveContainer;
import com.harrand.coregui.command.idf.ISpecificIdfRemoveCmd;
import com.harrand.coregui.table.TablePanel;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.command.PromptRemoveTableCmd;
import com.harrand.dbwrenchgui.command.RemoveSchCmd;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.panel.CustomTypePanel;
import com.harrand.dbwrenchgui.panel.DbEditPanel;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.dbwrenchgui.panel.ProcEditPanel;
import com.harrand.dbwrenchgui.panel.SchemaEditPanel;
import com.harrand.dbwrenchgui.panel.SequenceEditPanel;
import com.harrand.dbwrenchgui.panel.TableDetailsPanel;
import com.harrand.dbwrenchgui.panel.ViewEditPanel;
import com.harrand.dbwrenchgui.table.ColumnTableDriver;
import com.harrand.dbwrenchgui.table.CustomTypeTableDriver;
import com.harrand.dbwrenchgui.table.DiagramTableDriver;
import com.harrand.dbwrenchgui.table.ForeignKeyTableDriver;
import com.harrand.dbwrenchgui.table.IndexTableDriver;
import com.harrand.dbwrenchgui.table.NoteTableDriver;
import com.harrand.dbwrenchgui.table.ProcTableDriver;
import com.harrand.dbwrenchgui.table.SchemaTableDriver;
import com.harrand.dbwrenchgui.table.SequenceTableDriver;
import com.harrand.dbwrenchgui.table.TableTableDriver;
import com.harrand.dbwrenchgui.table.TriggerTableDriver;
import com.harrand.dbwrenchgui.table.ViewTableDriver;
import com.harrand.dbwrenchgui.table.ZoneTableDriver;
import com.harrand.dbwrenchgui.table.query.DbQueryTableDriver;
import com.harrand.dbwrenchnb.action.edit.EditorActionFactory;
import com.harrand.dbwrenchnb.panel.detail.IDetailLookupPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.NoteGlyph;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.glyph.interfaces.IDetailableGlyph;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.panel.NoteEditPanel;
import com.harrand.sketch.panel.ZoneEditPanel;
import com.harrand.util.LogUtil;
import javax.swing.JPanel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DetailLookupCtrl
implements IObserver {
    private IDetailLookupPanel detailsLookupPanel;
    private TablePanel tablePanel;
    private DbUser user_ = App.getUser();
    private TableDetailsPanel tableDetailsPanel_;
    private Lookup.Result dbResult_ = LookupUtil.createLookupResult(Database.class);
    private Lookup.Result collectorResult_ = LookupUtil.createLookupResult(CollectorMapNm.class);
    private Lookup.Result idfResult_ = LookupUtil.createLookupResult(CollectorIdf.class);
    private LookupListener collLookupLis_;
    private LookupListener idfLookupLis_;
    private LookupListener dbLookupLis_;
    private ISpecificIdfRemoveCmd specificRemoveCmd_ = null;

    public DetailLookupCtrl(IDetailLookupPanel detailsLookupPanel) {
        this.detailsLookupPanel = detailsLookupPanel;
        this.createLookupListeners();
        this.addLookupListeners();
        CentralLookup.getDefault().addObserver(this);
    }

    public void setTblDetailsTab(String keyNm) {
        if (this.tableDetailsPanel_ != null) {
            this.tableDetailsPanel_.setTab(keyNm);
        }
    }

    private void createLookupListeners() {
        this.createDbLookupListener();
        this.createIdfLookupListener();
        this.createCollectorLookupListener();
    }

    private void setDbPanel(Database db) {
        this.setTitleSuffix(db.getName());
        this.setDetailPanel(new DbEditPanel(db));
    }

    private void setFolderPanel(CollectorMapNm collMapNm) {
        this.setTitleSuffix(collMapNm.getDotNote());
        this.setGridPanel(collMapNm);
    }

    private void createDbLookupListener() {
        this.dbLookupLis_ = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance(ev);
                if (obj instanceof Database) {
                    DetailLookupCtrl.this.setDbPanel((Database)obj);
                }
            }
        };
    }

    private void createCollectorLookupListener() {
        this.collLookupLis_ = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance(ev);
                if (obj instanceof CollectorMapNm) {
                    DetailLookupCtrl.this.setFolderPanel((CollectorMapNm)obj);
                }
            }
        };
    }

    private void createIdfLookupListener() {
        this.idfLookupLis_ = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Object obj = LookupUtil.getFirstInstance(ev);
                if (obj instanceof CollectorIdf) {
                    CollectorIdf collIdf = (CollectorIdf)obj;
                    DetailLookupCtrl.this.setIdfPanel(collIdf);
                }
            }
        };
    }

    private TableDetailsPanel getTableDetailsPanel(Table table) {
        if (this.tableDetailsPanel_ == null) {
            this.tableDetailsPanel_ = TableDetailsPanel.getInstance();
            this.tableDetailsPanel_.setTable(table);
        } else {
            this.tableDetailsPanel_.setTable(table);
        }
        return this.tableDetailsPanel_;
    }

    private void setGridPanel(CollectorMapNm collMapNm) {
        Collector coll = collMapNm.getCollector();
        String mapNm = collMapNm.getMapNm();
        ITableDriver driver = this.getTableDriver(coll, mapNm);
        AddRemoveContainer gridPanel = null;
        if (driver != null) {
            this.tablePanel = new TablePanel(driver);
            gridPanel = new AddRemoveContainer((JPanel)this.tablePanel, false);
            gridPanel.setEditorActionFactory(EditorActionFactory.getInstance());
            gridPanel.setSpecificIdfRemoveCmd(this.specificRemoveCmd_);
        } else {
            LogUtil.logErr("DetailLookupCtrl.driver is null. colMapNm: " + collMapNm.getDotNote());
        }
        this.setDetailPanel(gridPanel);
    }

    private ITableDriver getTableDriver(Collector coll, String mapNm) {
        ITableDriver driver = null;
        this.specificRemoveCmd_ = null;
        if (mapNm.equals(Table.getClassName())) {
            driver = new TableTableDriver((Schema)coll, this.user_);
            this.specificRemoveCmd_ = new PromptRemoveTableCmd(((Schema)coll).getDb());
        } else if (mapNm.equals(Schema.getClassName())) {
            driver = new SchemaTableDriver((Database)coll);
            this.specificRemoveCmd_ = new RemoveSchCmd((Database)coll);
        } else if (mapNm.equals(Diagram.getClassName())) {
            driver = new DiagramTableDriver((Database)coll);
        } else if (mapNm.equals(DbQuery.getClassName())) {
            driver = new DbQueryTableDriver((Database)coll);
        } else if (mapNm.equals(View.getClassName())) {
            Schema schema = (Schema)coll;
            driver = new ViewTableDriver(schema);
        } else if (mapNm.equals(Proc.getClassName())) {
            Schema schema = (Schema)coll;
            driver = new ProcTableDriver(schema);
        } else if (mapNm.equals(Sequence.getClassName())) {
            driver = new SequenceTableDriver((Schema)coll);
        } else if (mapNm.equals(CustomType.getClassName())) {
            driver = new CustomTypeTableDriver((Schema)coll);
        } else if (mapNm.equals(Column.getClassName())) {
            driver = new ColumnTableDriver((Table)coll);
        } else if (mapNm.equals(ForeignKey.getClassName())) {
            driver = new ForeignKeyTableDriver((Table)coll, 1);
        } else if (mapNm.equals(Index.getClassName())) {
            driver = new IndexTableDriver((Table)coll);
        } else if (mapNm.equals(Trigger.getClassName())) {
            Table table = (Table)coll;
            driver = new TriggerTableDriver(table);
        } else if (mapNm.equals(Note.getClassName())) {
            driver = new NoteTableDriver((Diagram)coll);
        } else if (mapNm.equals(Zone.getClassName())) {
            driver = new ZoneTableDriver((Diagram)coll);
        }
        return driver;
    }

    private void setDetailPanel(JPanel panel) {
        this.detailsLookupPanel.setDetailsPanel(panel);
    }

    private void setTitleSuffix(String suffix) {
        this.detailsLookupPanel.setTitleSuffix(suffix);
    }

    private void setIdfPanel(CollectorIdf collIdf) {
        JPanel panel = null;
        Collector coll = collIdf.getCollector();
        Identifiable idf = collIdf.getIdentifiable();
        String mapNm = idf.getMapName();
        this.setTitleSuffix(collIdf.getDotNote());
        if (mapNm.equals(Schema.getClassName())) {
            panel = new SchemaEditPanel((Schema)idf);
        } else if (mapNm.equals(Diagram.getClassName())) {
            panel = null;
        } else if (mapNm.equals(Table.getClassName())) {
            panel = this.getTableDetailsPanel((Table)idf);
        } else if (mapNm.equals(View.getClassName())) {
            panel = new ViewEditPanel((View)idf);
        } else if (mapNm.equals(Proc.getClassName())) {
            panel = new ProcEditPanel((Proc)idf);
        } else if (mapNm.equals(Sequence.getClassName())) {
            panel = new SequenceEditPanel((Sequence)idf);
        } else if (mapNm.equals(CustomType.getClassName())) {
            panel = new CustomTypePanel((CustomType)idf, true);
        } else if (mapNm.equals(Column.getClassName())) {
            panel = null;
        } else if (mapNm.equals(ForeignKey.getClassName())) {
            panel = new ForeignKeyPanel((ForeignKey)idf, this.getDatabase());
        } else if (mapNm.equals(Index.getClassName())) {
            panel = null;
        } else if (mapNm.equals(Trigger.getClassName())) {
            panel = null;
        } else if (mapNm.equals(Note.getClassName())) {
            panel = new NoteEditPanel((Note)idf, (Diagram)coll, true);
        } else if (mapNm.equals(Zone.getClassName())) {
            panel = new ZoneEditPanel((Zone)idf, (Diagram)coll, true);
        }
        this.setDetailPanel(panel);
    }

    private void setGlyphPanel(Glyph selectedGlyph) {
        JPanel panel;
        String dotNote = null;
        Database db = LookupUtil.findDb();
        if (selectedGlyph instanceof DbTableGlyph) {
            DbTableGlyph tableGlyph = (DbTableGlyph)selectedGlyph;
            dotNote = tableGlyph.getName();
            Table table = db.getTableFromDotNote(dotNote);
            panel = this.getTableDetailsPanel(table);
        } else if (selectedGlyph instanceof ForeignKeyGlyph) {
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)selectedGlyph;
            dotNote = fkGlyph.getName();
            ForeignKey fk = db.getFkUtil().getFkFromDotNote(dotNote);
            panel = new ForeignKeyPanel(fk, db);
        } else if (selectedGlyph instanceof NoteGlyph) {
            NoteGlyph glyph = (NoteGlyph)selectedGlyph;
            Note note = glyph.getNote();
            Diagram diagram = glyph.getDiagram();
            panel = new NoteEditPanel(note, diagram, true);
        } else if (selectedGlyph instanceof ZoneGlyph) {
            ZoneGlyph glyph = (ZoneGlyph)selectedGlyph;
            Zone zone = glyph.getZone();
            Diagram diagram = glyph.getDiagram();
            panel = new ZoneEditPanel(zone, diagram, true);
        } else {
            panel = new JPanel();
        }
        this.setTitleSuffix(dotNote);
        this.setDetailPanel(panel);
    }

    private void addLookupListeners() {
        this.dbResult_.addLookupListener(this.dbLookupLis_);
        this.collectorResult_.addLookupListener(this.collLookupLis_);
        this.idfResult_.addLookupListener(this.idfLookupLis_);
    }

    private Database getDatabase() {
        return (Database)CentralLookup.getDefault().lookup(Database.class);
    }

    @Override
    public void update(UpdateChain chain) {
        Glyph glyph;
        this.isLookupItemSet(CollectorMapNm.class);
        this.isLookupItemSet(CollectorIdf.class);
        this.isLookupItemSet(Glyph.class);
        boolean isFromLookup = this.isFromLookup(chain);
        if (isFromLookup && this.hasClassNm(chain, Database.class)) {
            Database db = LookupUtil.getLookupDb();
            if (db != null) {
                this.setDbPanel(db);
            } else {
                this.setEmptyPanel();
            }
        }
        if (isFromLookup && this.hasClassNm(chain, CollectorMapNm.class)) {
            CollectorMapNm collMapNm = (CollectorMapNm)CentralLookup.getDefault().lookup(CollectorMapNm.class);
            if (collMapNm != null) {
                this.setGridPanel(collMapNm);
            } else {
                this.setEmptyPanel();
            }
        }
        if (isFromLookup && this.hasClassNm(chain, CollectorIdf.class)) {
            CollectorIdf collIdf = (CollectorIdf)CentralLookup.getDefault().lookup(CollectorIdf.class);
            if (collIdf != null) {
                this.setIdfPanel(collIdf);
            } else {
                this.setEmptyPanel();
            }
        }
        if (chain.hasInteface(Glyph.class.getName()) && (glyph = (Glyph)CentralLookup.getDefault().lookup(Glyph.class)) instanceof IDetailableGlyph) {
            this.setGlyphPanel(glyph);
        }
    }

    private void isLookupItemSet(Class clz) {
        Object obj = CentralLookup.getDefault().lookup(clz);
    }

    private void setEmptyPanel() {
        this.setDetailPanel(null);
    }

    private boolean isFromLookup(UpdateChain chain) {
        return chain.hasClassName(CentralLookup.class.getName());
    }

    private boolean hasClassNm(UpdateChain chain, Class clazz) {
        return chain.hasClassName(clazz.getName());
    }
}

