/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.menu.ctrl;

import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.dbwrench.diagram.DbDrawableOrderer;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.sketch.command.PromptExportDiagram;
import com.harrand.sketch.core.Diagram;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;

public class ExportDiagramCtrl
extends JMenu
implements DynamicMenuContent {
    private String menuText_ = "(text unset)";
    private String formatName_;
    private IFileUseMgr fileUseMgr_ = App.getFileUseMgr();
    private Database db_ = null;

    public ExportDiagramCtrl(String menuText, String formatName) {
        super(menuText);
        this.menuText_ = menuText;
        this.formatName_ = formatName;
    }

    private void refresh() {
        this.removeAll();
        this.db_ = this.getLookupDb();
        if (this.isDbSet()) {
            List diagrams = this.db_.getDiagrams();
            if (diagrams.isEmpty()) {
                this.addDisabledItem("<no diagrams>");
            } else {
                this.refreshMnis(diagrams);
            }
        } else {
            this.addDisabledItem("<no database open>");
        }
    }

    private void refreshMnis(List diagrams) {
        for (Diagram diagram : diagrams) {
            PromptExportDiagram cmd = new PromptExportDiagram(diagram, new DbDrawableOrderer(), this.formatName_, this.fileUseMgr_, diagram.getName());
            JMenuItem mni = new JMenuItem(cmd);
            this.add(mni);
        }
    }

    private void addDisabledItem(String itemText) {
        JMenuItem item = new JMenuItem(itemText);
        item.setEnabled(false);
        this.add(item);
    }

    public JComponent[] getMenuPresenters() {
        this.refresh();
        return new JComponent[]{this};
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.getMenuPresenters();
    }

    private boolean isDbSet() {
        return this.db_ != null;
    }

    private Database getLookupDb() {
        return (Database)CentralLookup.getDefault().lookup(Database.class);
    }
}

