/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.menu;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchnb.nb.NbUtil;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class UndoRedoToolbar
extends JToolBar
implements IObserver {
    private static UndoRedoToolbar instance__ = new UndoRedoToolbar();
    private CommandChain cmdChain_ = App.getCommandChain();
    private JButton btnUndo_;
    private JButton btnRedo_;

    private UndoRedoToolbar() {
        this.initBtns();
        this.add(this.btnUndo_);
        this.add(this.btnRedo_);
        this.cmdChain_.addObserver(this);
        this.updateBtns();
    }

    public static UndoRedoToolbar getInstance() {
        return instance__;
    }

    public void setCommandChain(CommandChain cmdChain) {
        if (this.cmdChain_ != null) {
            this.cmdChain_.removeObserver(this);
        }
        this.cmdChain_ = cmdChain;
        this.cmdChain_.addObserver(this);
    }

    private void initBtns() {
        this.btnUndo_ = new JButton(Icons.UNDO);
        this.btnRedo_ = new JButton(Icons.REDO);
        this.btnUndo_.setEnabled(false);
        this.btnRedo_.setEnabled(false);
        this.btnUndo_.setMinimumSize(new Dimension(18, 18));
        this.btnRedo_.setMinimumSize(new Dimension(18, 18));
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateBtns();
    }

    private void updateBtn(JButton btn, Command cmd) {
        if (cmd != null) {
            btn.setEnabled(true);
            String tooltip = (String)cmd.getValue("Name");
            cmd.putValue("Name", null);
            btn.setAction(cmd);
            btn.setToolTipText(tooltip);
        } else {
            btn.setEnabled(false);
        }
    }

    private void updateBtns() {
        if (this.cmdChain_ != null) {
            Command undoCommand = this.cmdChain_.getUndoCommand();
            Command redoCommand = this.cmdChain_.getRedoCommand();
            this.updateBtn(this.btnUndo_, undoCommand);
            this.updateBtn(this.btnRedo_, redoCommand);
        } else {
            NbUtil.logMsg("UndoRedoPanel Command Chain is null.");
        }
    }
}

