/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.menu;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.list.IconListCellRenderer;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class PickConnection
extends CallableSystemAction
implements IObserver {
    private JComboBox combo_;
    private ActionListener lisCombo_;
    private Database filterDb_;
    private DbUser dbUser_ = App.getUser();
    private IOptionMgr conOptMgr_;
    private IOptionMgr forEngOptMgr_;

    public PickConnection() {
        this.dbUser_.addObserver(this);
        CentralLookup.getDefault().addObserver(this);
        this.conOptMgr_ = this.dbUser_.getOptionMgr("conn.opt.mgr");
        this.forEngOptMgr_ = this.dbUser_.getOptionMgr("forward.engineer.option.mgr");
        this.buildComboBox();
        this.addListeners();
        this.setLastConn();
    }

    public void performAction() {
    }

    public Component getToolbarPresenter() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new JLabel("Connection:"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.combo_);
        panel.add(Box.createHorizontalStrut(20));
        return panel;
    }

    public void setFilterDatabase(Database db) {
        this.filterDb_ = db;
        this.loadConnectionConfigs();
    }

    public Database getFilterDatabase() {
        return this.filterDb_;
    }

    private void buildComboBox() {
        this.combo_ = new JComboBox();
        this.combo_.setName("configCombo");
        this.combo_.setRenderer(new IconListCellRenderer());
        this.loadConnectionConfigs();
    }

    private void addListeners() {
        this.lisCombo_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickConnection.this.saveLastConn();
                PickConnection.this.updateConnMgr();
            }
        };
        this.combo_.addActionListener(this.lisCombo_);
    }

    private void setLastConn() {
        int lastConnIdx = this.conOptMgr_.getIntValue("last.conn.idx");
        if (lastConnIdx >= 0) {
            if (lastConnIdx < this.combo_.getItemCount()) {
                this.combo_.setSelectedIndex(lastConnIdx);
            } else {
                LogUtil.logErr("PickConn.lastConnIdx exceeds combo range: " + lastConnIdx);
            }
        } else {
            LogUtil.logErr("PickConn.lastConnIdx.unset: " + lastConnIdx);
        }
    }

    private void saveLastConn() {
        int selectedIndex = this.combo_.getSelectedIndex();
        this.conOptMgr_.setIntValue("last.conn.idx", selectedIndex);
    }

    private void updateConnMgr() {
        ConnMgr mgr = ConnMgr.getInstance();
        mgr.setCurrentCfg(this.getSelectedConn());
    }

    private JdbcConfig getSelectedConn() {
        JdbcConfig selected = null;
        selected = (JdbcConfig)this.combo_.getSelectedItem();
        return selected;
    }

    private void loadConnectionConfigs() {
        List configs = this.dbUser_.values(JdbcConfig.clazz());
        int connCount = configs.size();
        if (this.filterDb_ != null) {
            ArrayList<JdbcConfig> keepConfigs = new ArrayList<JdbcConfig>();
            for (JdbcConfig config : configs) {
                String dbName = config.getObjectInstanceName();
                if (dbName.equalsIgnoreCase(this.filterDb_.getName())) {
                    keepConfigs.add(config);
                    continue;
                }
                if (config.getDbmsId() != 2) continue;
                keepConfigs.add(config);
            }
            configs.retainAll(keepConfigs);
        }
        configs.addAll(JdbcConfig.getGenericConfigs());
        GuiHelper.loadComboBox(this.combo_, configs.toArray());
        this.updateConnMgr();
    }

    private String getItemOneString(int connCount) {
        String str = connCount > 0 ? "<No Connection Selected>" : "<No Connections Defined>";
        return str;
    }

    public String getName() {
        return "Pick Server Connection";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void checkDbChanged() {
        boolean doFiltering = this.forEngOptMgr_.getBoolValue("forward.engineer.filter.conn");
        if (!doFiltering) {
            this.filterDb_ = null;
            this.loadConnectionConfigs();
        } else {
            Database currentDb = LookupUtil.findDb();
            if (currentDb != null) {
                boolean changed;
                boolean bl = changed = !currentDb.equals(this.filterDb_);
                if (changed) {
                    this.filterDb_ = currentDb;
                    this.loadConnectionConfigs();
                }
            }
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IConnectionConfig.class.getName())) {
            this.loadConnectionConfigs();
        }
        if (chain.hasClassName(CentralLookup.class.getName()) && chain.hasClassName(Database.class.getName())) {
            this.checkDbChanged();
        }
    }
}

