/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.lifecycle.db;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchnb.action.db.SaveContext;
import com.harrand.dbwrenchnb.action.db.SaveUtil;
import com.harrand.dbwrenchnb.lifecycle.db.DbFullDirtyChecker;

public class DbSaveChecker {
    public void checkSave(boolean useMultithreadedSave) {
        Database db = LookupUtil.getLookupDb();
        if (db != null) {
            SaveContext saveContext = new SaveContext();
            saveContext.setIsAutoSave(false);
            saveContext.setIsSaveAs(false);
            saveContext.setUseMultithreadedSave(useMultithreadedSave);
            SaveUtil.getInstance().saveAll(saveContext);
        }
    }

    public boolean getDirty() {
        DbFullDirtyChecker dirtyChecker = new DbFullDirtyChecker();
        return dirtyChecker.getDirty();
    }

    public void checkAutoSave() {
        boolean autosaveOn = false;
        DbUser user = App.getUser();
        if (user != null) {
            IOptionMgr dbExplorerOptionMgr = user.getOptionMgr("db.explorer.option.mgr");
            autosaveOn = dbExplorerOptionMgr.getBoolValue("db.explorer.autosave");
        }
        Database db = LookupUtil.getLookupDb();
        if (autosaveOn && db != null && this.getDirty() && db.getFolder() != null) {
            SaveContext saveContext = new SaveContext();
            saveContext.setIsAutoSave(true);
            saveContext.setIsSaveAs(false);
            saveContext.setUseMultithreadedSave(true);
            SaveUtil.getInstance().saveAll(saveContext);
        }
    }
}

