/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.editor;

import com.harrand.coreclasses.db.SqlResult;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.text.TextChangedMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.FocusRestorer;
import com.harrand.dbwrench.db.comm.ISqlResultObserver;
import com.harrand.dbwrench.db.comm.SqlSender;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.dbwrenchnb.server.SqlResultsTopComponent;
import com.harrand.dbwrenchnb.server.conn.ConnChecker;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.openide.windows.TopComponent;

@Deprecated
public class SqlEditor
extends TopComponent
implements ISqlResultObserver,
IObserver {
    public static final String UNTITLED = "(untitled)";
    private JButton btnSaveFile_ = new JButton("Save File");
    private JButton btnExec_ = new JButton("Execute SQL");
    private JLabel lblStatus_ = new JLabel("");
    private NbEditPanel editPanel_;
    private JTextComponent txtComp_;
    private TextChangedMgr textChangedMgr_ = new TextChangedMgr();
    private SqlSender sqlSender_ = SqlSender.getInstance();
    private IFileUseMgr fileUseMgr_ = App.getFileUseMgr();
    private File file_ = null;
    private FocusRestorer focusRestorer_;
    public static final String PREFERRED_ID = "SqlEditor";

    public SqlEditor() {
        this.initPanel();
        this.layoutPanel();
        this.setCosmetics();
        this.addListeners();
        this.attachSqlProcessObservers();
        this.refreshFileStrs();
        this.buildFocusRestorer();
        this.setText("");
    }

    public final void setText(String text) {
        this.editPanel_.setText(text);
        this.textChangedMgr_.setLastText(text);
    }

    public void setFile(File file) {
        this.file_ = file;
        this.setText(FileHelper.readFileToString(this.file_));
        this.refreshFileStrs();
    }

    protected void componentActivated() {
        this.editPanel_.setTCActions(this);
    }

    private void addListeners() {
        this.btnExec_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlEditor.this.execSql();
            }
        });
        this.btnSaveFile_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlEditor.this.save();
            }
        });
    }

    private void attachSqlProcessObservers() {
        SqlResultsTopComponent resultsTC = this.getResultsTC();
        this.sqlSender_.addSqlProcessObserver(resultsTC);
    }

    private void clearResults() {
        SqlResultsTopComponent resultsTC = this.getResultsTC();
        resultsTC.clear();
    }

    private void refresh() {
        this.btnExec_.setEnabled(this.sqlSender_.isFinished());
    }

    private void refreshFileStrs() {
        this.refreshTitle();
        this.refreshToolTip();
    }

    private void refreshTitle() {
        String title;
        String string = title = this.isFileSet() ? this.file_.getName() : UNTITLED;
        if (this.textChangedMgr_.getHasChanged(this.txtComp_.getText())) {
            title = title + "*";
        }
        this.setDisplayName(title);
    }

    private void refreshToolTip() {
        String tip = this.isFileSet() ? this.file_.getPath() : "SQL Editor & Communicator";
        this.setToolTipText(tip);
    }

    private void buildFocusRestorer() {
        ArrayList<JTextComponent> comps = new ArrayList<JTextComponent>();
        comps.add(this.txtComp_);
        this.focusRestorer_ = new FocusRestorer(comps);
    }

    private void showResultsWindow() {
        SqlResultsTopComponent resultsTC = this.getResultsTC();
        if (!resultsTC.isOpened()) {
            resultsTC.open();
        }
        resultsTC.requestActive();
        resultsTC.requestAttention(true);
    }

    private void save() {
        if (this.checkFileSet()) {
            FileHelper.saveStringToFile(this.txtComp_.getText(), this.file_);
            this.textChangedMgr_.setLastText(this.txtComp_.getText());
            this.refreshFileStrs();
            this.updateFileUseMgr();
            this.focusRestorer_.restoreFocus();
        }
    }

    private boolean checkFileSet() {
        boolean isSet = false;
        if (this.isFileSet()) {
            isSet = true;
        } else {
            File promptFile = GuiMessageHelper.promptForSaveFile(this.getDefaultPromptFile());
            if (promptFile != null) {
                isSet = true;
                this.file_ = promptFile;
            }
        }
        return isSet;
    }

    private File getDefaultPromptFile() {
        File mgrFile = this.fileUseMgr_ != null ? this.fileUseMgr_.getDefaultFile("SqlScript", null) : new File("");
        File pathFile = this.file_ != null ? this.file_ : mgrFile;
        return pathFile;
    }

    private void updateFileUseMgr() {
        if (this.fileUseMgr_ != null) {
            this.fileUseMgr_.addRecentFile("SqlScript", this.file_, true);
        }
    }

    private SqlResultsTopComponent getResultsTC() {
        SqlResultsTopComponent tc = SqlResultsTopComponent.findInstance();
        return tc;
    }

    private void execSql() {
        this.clearResults();
        this.showResultsWindow();
        JdbcConfig currentCfg = ConnMgr.getInstance().getCurrentCfg();
        if (ConnChecker.isConfigValid(currentCfg)) {
            String sqlText = this.getSendText();
            this.sqlSender_.sendSql(this.btnExec_, this.lblStatus_, sqlText);
        }
    }

    private String getSendText() {
        String selectedText = this.editPanel_.getSelectedText();
        String sendText = selectedText == null || selectedText.length() <= 0 ? this.editPanel_.getText() : selectedText;
        return sendText;
    }

    private void initPanel() {
        this.initEditor();
    }

    private void initEditor() {
        this.editPanel_ = new NbEditPanel(false);
        this.txtComp_ = this.editPanel_.getTextComponenet();
        this.editPanel_.addObserver(this);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.getHeaderPanel(), "North");
        this.add(this.editPanel_, "Center");
        this.add(this.getSouthPanel(), "South");
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("SQL Editor & Communicator", "Send SQL statements to the server");
        return header;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.getBtnPanel());
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.lblStatus_);
        panel.add(Box.createGlue());
        panel.add(this.btnExec_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnSaveFile_);
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        panel.setBorder(border);
        return panel;
    }

    private void setCosmetics() {
        this.refreshTitle();
        this.refreshToolTip();
        this.setIcon(Icons.SQL_COMM.getImage());
        this.btnSaveFile_.setMnemonic(83);
        this.btnSaveFile_.setIcon(Icons.SAVE_AS);
        this.btnExec_.setMnemonic(88);
        this.btnExec_.setIcon(Icons.EXECUTE);
    }

    private boolean isFileSet() {
        return this.file_ != null;
    }

    private void setDummyText() {
        this.setText("INSERT INTO public.account \n(id, descr, insert_by_id, update_by_id, insert_time, update_time)\nVALUES (1, 'myAcct', 1, 1, now(), now());\nDELETE FROM public.account WHERE id = 1;");
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public void updateResult(SqlResult result, int resultIdx) {
        this.refresh();
    }

    @Override
    public void updateGeneral() {
        this.refresh();
    }

    @Override
    public void setCmdCount(int cmdCount) {
    }

    @Override
    public void update(UpdateChain chain) {
        this.refreshTitle();
    }
}

