/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.diagram;

import com.harrand.coregui.Icons;
import com.harrand.dbwrenchgui.diagram.NavigatorPanel;
import com.harrand.dbwrenchnb.diagram.Bundle;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="NavigatorTopComponent", persistenceType=0)
public final class NavigatorTopComponent
extends TopComponent {
    private NavigatorPanel nvPanel_ = new NavigatorPanel();
    private JLabel mouseOverLabel_ = new JLabel();
    private static final int NV_GAP = 5;
    private static final int NV_BORDER = 2;

    public NavigatorTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_NavigatorTopComponent());
        this.setToolTipText(Bundle.HINT_NavigatorTopComponent());
        this.buildPanel();
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
    }

    public NavigatorPanel getNvPanel() {
        return this.nvPanel_;
    }

    public void updateNvSize() {
        int heightLbl = 22;
        int tcHeight = this.getHeight();
        int tcWidth = this.getWidth();
        Dimension newSz = new Dimension(tcWidth - 0, tcHeight - heightLbl);
        this.nvPanel_.setMaxSize(newSz);
        this.nvPanel_.refresh();
    }

    private void addListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavigatorTopComponent.this.updateNvSize();
                NavigatorTopComponent.this.nvPanel_.refresh();
            }
        });
    }

    private void buildPanel() {
        this.nvPanel_.setMouseOverLabel(this.mouseOverLabel_);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.nvPanel_, "Center");
        this.add(this.mouseOverLabel_, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    private void setCosmetics() {
        this.setDisplayName("Navigator");
        this.setToolTipText("Diagram Navigator");
        this.setIcon(Icons.DIAGRAM.getImage());
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

