/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.diagram;

import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphLocator;
import com.harrand.sketch.core.IDiagramSrv;
import com.harrand.sketch.glyph.mgr.GlyphSelectionMgr;
import com.harrand.sketch.interfaces.INavigator;
import com.harrand.sketch.j2d.SelectedGlyphBlinker;
import com.harrand.sketch.panel.diagram.IDiagramScroller;
import com.harrand.sketch.prefs.diagram.GlyphLocatePrefCtrl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GlyphLocateMgr {
    private static GlyphLocateMgr instance__ = new GlyphLocateMgr();
    private GlyphLocator glyphLocator_;
    private ViewportMoveCtrl viewportMoveCtrl_;
    private INavigator navigator_;
    private JScrollPane scrollPane_;
    private Diagram diagram_;
    private IRefreshable refreshableDiaPanel;
    private IDiagramScroller diagramScroller;

    public static GlyphLocateMgr getInstance() {
        return instance__;
    }

    public void setDiagramScroller(IDiagramScroller diagramScroller) {
        this.diagramScroller = diagramScroller;
        this.init();
    }

    public void locateGlyph(String glyphNm) {
        if (this.diagramScroller != null && this.diagramScroller.isShowing()) {
            Diagram containingDiagram = this.glyphLocator_.getContainingDiagram(glyphNm, this.diagram_);
            if (containingDiagram != null) {
                if (this.diagram_.getName().equals(containingDiagram.getName())) {
                    this.locateGlyphDetails(this.diagram_, glyphNm);
                } else {
                    this.unselectGlyphs();
                }
            } else {
                this.unselectGlyphs();
            }
        }
    }

    private void locateGlyphDetails(Diagram glyphDiagram, String glyphNm) {
        Glyph glyph = glyphDiagram.getGlyphOrLink(glyphNm);
        boolean doSlide = GlyphLocatePrefCtrl.getInstance().getSlideToLocateFlag();
        this.selectGlyph(glyphNm);
        JViewport viewport = this.scrollPane_.getViewport();
        Dimension viewportSize = viewport.getSize();
        Point newViewPos = this.glyphLocator_.getViewPosition(glyph, glyphDiagram, viewportSize);
        int fontSz = glyphDiagram.getRenderConfig().getFont().getSize();
        this.viewportMoveCtrl_.setFontSize(fontSz);
        this.viewportMoveCtrl_.setZoomLevel(glyphDiagram.getZoom().getLevel());
        if (doSlide) {
            this.viewportMoveCtrl_.moveViewSlowly(newViewPos);
        } else {
            this.viewportMoveCtrl_.moveViewDirectly(newViewPos);
        }
        this.refreshableDiaPanel.refresh();
        this.updateNvPortalDisp();
        this.blinkSelectedGlyphs();
    }

    private void init() {
        this.scrollPane_ = this.diagramScroller.getScrollPane();
        this.diagram_ = this.diagramScroller.getDiagram();
        this.refreshableDiaPanel = this.diagramScroller.getRefreshable();
        this.glyphLocator_ = new GlyphLocator(this.getDatabase());
        this.viewportMoveCtrl_ = new ViewportMoveCtrl(this.scrollPane_.getViewport());
    }

    private void selectGlyph(String glyphNm) {
        ArrayList<String> selectedGlyphNms = new ArrayList<String>();
        selectedGlyphNms.add(glyphNm);
        this.getGlyphSelectionMgr().setSelectedGlyphs(selectedGlyphNms);
        this.refreshableDiaPanel.refresh();
    }

    private void unselectGlyphs() {
        this.getGlyphSelectionMgr().setSelectedGlyphs(new ArrayList());
        this.refreshableDiaPanel.refresh();
    }

    private GlyphSelectionMgr getGlyphSelectionMgr() {
        return this.diagram_.getSelectionMgr();
    }

    private void blinkSelectedGlyphs() {
        SelectedGlyphBlinker blinker = new SelectedGlyphBlinker(this.refreshableDiaPanel, this.diagram_);
        blinker.doBlinks();
    }

    private void updateNvPortalDisp() {
        this.updateNavigatorPortal();
    }

    private void updateNavigatorPortal() {
        if (this.isNavigatorSet()) {
            this.navigator_.setPortalInDiaCoords(this.getPortal());
        }
    }

    private boolean isNavigatorSet() {
        return this.navigator_ != null;
    }

    public Rectangle2D getPortal() {
        Rectangle vpRect = this.scrollPane_.getViewport().getViewRect();
        return GeometryHelper.getRect2D(vpRect);
    }

    private IDiagramSrv getDatabase() {
        return LookupUtil.findDb();
    }
}

